/*--------------------------------------------------------------------------
  Additional kernel code to show initial 'signs of life' on MC2 hardware.
  
  (c) 2007 Dark Matter Digital Inc

 This file is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 --------------------------------------------------------------------------*/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/param.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <asm/irq.h>
#include <asm/dma.h>
#include <asm/traps.h>
#include <asm/machdep.h>
#include <asm/coldfire.h>
#include <asm/mcftimer.h>
#include <asm/mcfsim.h>
#include <asm/mcfdma.h>
#include <asm/mcfwdebug.h>

/***************************************************************************/

#define CONFIG_MC2_SHOW_LIFE

/***************************************************************************/

#if defined(CONFIG_M532X_MC2) && defined(CONFIG_MC2_SHOW_LIFE)

#include "../../../../drivers/spi/mcf_qspi.h" 

#define LED_SPI_RATE 	(20000000/1000000)

#define COMMAND_NOOP		0x00
#define COMMAND_DECODE_MODE	0x01
#define COMMAND_INTENSITY	0x02
#define COMMAND_SCAN_LIMIT	0x03
#define COMMAND_CONFIGURATION	0x04
#define COMMAND_TEST		0x07

#define LED_MAX_BRIGHTNESS	0x0F

/**
 * 
 * 
 * @return 
 */
void led_qspi_write(const char *dbuf, size_t length)
{
        int i = 0;
        int qcr_cs;
	int z = QCR_SETUP;
        int total = 0;

	u16 baud =  (MCF_BUSCLK/1000000) / (2*LED_SPI_RATE) ;

        QMR = QMR_MSTR |
                (0 << 14) |		/* dohie : QSPI_DOUT is driven between transfers */
                (8 << 10) |		/* bits  : 8-bits per transfer */
                (0l << 9) |		/* cpol: */
                (0 << 8)  |		/* cpha */
                baud;

        QDLYR = (17 << 8) | 		/* qcd */
		1;			/* dtl */

	qcr_cs = 0xf00 & ~(1 << (8+1));		//SPI_CS1 = OLED SPI select 

        while (i < length) {
                int x;
                int n;
		
                QAR = TX_RAM_START;             /* address: first QTR */
                {
                        /* 8bit transfers */
                        for (n = 0; n < 16; ) {
                                QDR = dbuf[i];  /* tx data: QTR write */
                                n++;
                                i++;
                                if (i == length)
                                        break;
                        }
                }

                QAR = COMMAND_RAM_START;        /* address: first QCR */
                if( n>0 ) {
                    for (x = 0; x < n; x++) {
                        /* QCR write */
                        {
                                if (x == n-1 && i == length)
                                        if ((i % 2)!= 0)
                                                QDR = z | qcr_cs; /* last transfer and odd number of chars */
                                        else
                                                QDR = QCR_SETUP | qcr_cs;       /* last transfer */
                                else
                                        QDR = QCR_CONT | QCR_SETUP | qcr_cs;
                        } 
                    }

                    QWR = QWR_CSIV | ((n - 1) << 8); /* QWR[ENDQP]=n<<8 */

                    /* Polling increases
                     * performance for samll data transfers but is dangerous
                     * if we stay too long here, locking other tasks!!
                     */
                    {
                        QIR = QIR_SETUP_POLL;
                        QDLYR |= QDLYR_SPE;

                        while ((QIR & QIR_SPIF) != QIR_SPIF)
                                ;
                        QIR = QIR | QIR_SPIF;
                    } 
                }
                total += n;
        }

}

/**
 * Send command to set register in MAX6950/MAX6951
 *
 */
void LEDSendCommand(unsigned char  command, unsigned char  val)
{
	unsigned char  msg[2];

	msg[0] = command;
	msg[1] = val;

	led_qspi_write(msg, 2);
}

/**
 * 
 *
 */
void showlife_mc(void)
{
	MCF_GPIO_PAR_QSPI = 0xFFF0;	/* Switch QSPI pins to primary function */

	LEDSendCommand(COMMAND_TEST, 0x00);				// Test mode off
	LEDSendCommand(COMMAND_DECODE_MODE, 0);				// No decode mode
	LEDSendCommand(COMMAND_SCAN_LIMIT, 0x07);			// All digits enabled
//	LEDSendCommand(COMMAND_INTENSITY, LED_MAX_BRIGHTNESS/4);	// Set mid brightness as default
	LEDSendCommand(COMMAND_CONFIGURATION, 0x01);			// Normal operation, no blinking

	LEDSendCommand(COMMAND_TEST, 0x01);				// Test mode on
}

#endif	//defined(CONFIG_M532X_MC2) && defined(CONFIG_MC2_SHOW_LIFE)

