#if !defined(MCF_QSPI_H)
#define MCF_QSPI_H

#include <linux/spi/mcfqspi.h>
#include <linux/types.h>


#define QSPI_MAJOR              126
#define QSPI_MAX_BUF            32
#if (defined(CONFIG_M5249) || defined(CONFIG_M5253))
#define MCFQSPI_IRQ_VECTOR      27
#define QSPIMOD_OFFSET          0x400
#elif defined(CONFIG_M5235)
#define MCF5235ICM_INTC0	0xC00
#define MCFINTC0_ICR		0x40
#define MCFQSPI_IRQ_VECTOR	82
#define QSPIMOD_OFFSET		0x340
#define IRQ_SOURCE		18
#define MCF5235INTC_IMRL	0x0C
#elif (defined(CONFIG_M5282) || defined(CONFIG_M5280))
#define MCFQSPI_IRQ_VECTOR      (64 + 18)
#define QSPIMOD_OFFSET          0x340
#elif defined(CONFIG_M532x)
#define MCFQSPI_IRQ_SOURCE	31
#define MCFQSPI_IRQ_VECTOR	(64 + MCFQSPI_IRQ_SOURCE)
#define QSPIMOD_OFFSET		0xFC05C000
#elif defined(CONFIG_M527X_MC2)
#define MCFQSPI_IRQ_VECTOR      (64 + 18)
#define QSPIMOD_OFFSET          0x340
#elif defined(CONFIG_M5272)
#define MCFQSPI_IRQ_VECTOR      89
#define QSPIMOD_OFFSET          0xa0
#elif defined(CONFIG_M520x)
#define MCFQSPI_IRQ_VECTOR      (MCFINT_VECBASE+MCFINT_QSPI)
#define QSPIMOD_OFFSET          0x5C000
#else
#define MCFQSPI_IRQ_VECTOR      89
#define QSPIMOD_OFFSET          0xa0
#endif


/* QSPI registers */
#define MCFSIM_QMR              (0x00 + QSPIMOD_OFFSET) /* mode */
#define MCFSIM_QDLYR            (0x04 + QSPIMOD_OFFSET) /* delay */
#define MCFSIM_QWR              (0x08 + QSPIMOD_OFFSET) /* wrap */
#define MCFSIM_QIR              (0x0c + QSPIMOD_OFFSET) /* interrupt */
#define MCFSIM_QAR              (0x10 + QSPIMOD_OFFSET) /* address */
#define MCFSIM_QDR              (0x14 + QSPIMOD_OFFSET) /* data */

#define TX_RAM_START            0x00
#define RX_RAM_START            0x10
#define COMMAND_RAM_START       0x20

#if defined(CONFIG_M520x)
#define QMR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QMR)
#define QAR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QAR)
#define QDR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QDR)
#define QWR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QWR)
#define QDLYR                   *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QDLYR)
#define QIR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QIR)
#elif defined(CONFIG_M527X_MC2)
#define QMR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QMR)
#define QAR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QAR)
#define QDR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QDR)
#define QWR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QWR)
#define QDLYR                   *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QDLYR)
#define QIR                     *(volatile u16 *)(MCF_IPSBAR + MCFSIM_QIR)
#else
#define QMR                     *(volatile u16 *)(MCF_MBAR + MCFSIM_QMR)
#define QAR                     *(volatile u16 *)(MCF_MBAR + MCFSIM_QAR)
#define QDR                     *(volatile u16 *)(MCF_MBAR + MCFSIM_QDR)
#define QWR                     *(volatile u16 *)(MCF_MBAR + MCFSIM_QWR)
#define QDLYR                   *(volatile u16 *)(MCF_MBAR + MCFSIM_QDLYR)
#define QIR                     *(volatile u16 *)(MCF_MBAR + MCFSIM_QIR)
#endif

/* QMR bit settings */
#define QMR_MSTR                0x8000  /* master mode enable: must always be set */
#define QMR_DOHIE               0x4000  /* shut off (hi-z) Dout between transfers */
#define QMR_BITS                0x3c00  /* bits per transfer (size) */
#define QMR_CPOL                0x0200  /* clock state when inactive */
#define QMR_CPHA                0x0100  /* clock phase: 1 = data taken at rising edge */
#define QMR_BAUD                0x00ff  /* clock rate divider */

/* QIR bit settings */
#if defined(CONFIG_M520x)
#define QIR_SPIF            0x0001  /* QSPI transfer finished flag, write=1 => clear */
#define QIR_ABRT            0x0004  /* abort flag, write=1 => clear */
#define QIR_WCEF            0x0008  /* write collision error flag, write=1=> clear */
#define QIR_SPIFE           0x0100  /* enable spi interrupts */
#define QIR_ABRTE           0x0400  /* abort interrupt enable */
#define QIR_WCEFE           0x0800  /* write collision interrupt enable */
#define QIR_ABRTL           0x1000  /* abort lock out */
#define QIR_ABRTB           0x4000  /* abort access error enable */
#define QIR_WCEFB           0x8000  /* write collision access error enable*/
#define QIR_SETUP_POLL      (QIR_SPIF|QIR_ABRT|QIR_WCEF|QIR_ABRTL|QIR_ABRTB|QIR_WCEFB)
#define QIR_SETUP_IRQ       (QIR_SETUP_POLL|QIR_WCEFE|QIR_ABRTE|QIR_SPIFE)
#else
#define QIR_WCEF                0x0008  /* write collison */
#define QIR_ABRT                0x0004  /* abort */
#define QIR_SPIF                0x0001  /* finished */
#define QIR_SETUP_IRQ           0xdd0f  /* setup QIR for tranfer start */
#define QIR_SETUP_POLL          0xdc0d  /* setup QIR for tranfer start */
#endif

#define QWR_CSIV                0x1000  /* 1 = active low chip selects */
#define QWR_CSIV_HIGH           0x0000  /* 0 = active high chip selects */

#define QDLYR_SPE               0x8000  /* initiates transfer when set */
#define QDLYR_QCD               0x7f00  /* start delay between CS and first clock */
#define QDLYR_DTL               0x00ff  /* delay after CS release */

/* QCR: chip selects return to inactive, bits set in QMR[BITS],
 * after delay set in QDLYR[DTL], pre-delay set in QDLYR[QCD] */
#define QCR_SETUP               0x7000
#define QCR_CONT                0x8000  /* 1=continuous CS after transfer */
#define QCR_SETUP8              0x3000  /* sets BITSE to 0 => eigth bits per transfer */

/************************ BEGIN QSPI register settings ***********************/
/* QMR settings */
#if defined(CONFIG_M532X_MC2) || defined(CONFIG_M527X_MC2)
#define QMR_DEFAULT_BAUD        1000  	// khz
#else
#define QMR_DEFAULT_BAUD        1  	// Mhz
#endif

#define QMR_BAUD_MAX            0xff
#define QMR_BAUD_MIN            0x02
/************************ END QSPI register settings ***********************/

typedef struct qspi_dev {
        qspi_read_data read_data;
        u8 bits;                        /* transfer size, number of bits to transfer for each entry */
        u8 baud;                        /* baud rate */
        u8 qcd;                         /* QSPILCK delay */
        u8 dtl;                         /* delay after transfer */
        unsigned int qcr_cont   : 1;    /* keep CS active throughout transfer */
        unsigned int odd_mod    : 1;    /* if length of buffer is a odd number, 16-bit transfers
                                           are finalized with a 8-bit transfer */
        unsigned int dsp_mod    : 1;    /* transfers are bounded to 15/30 bytes
                                           (= a multiple of 3 bytes = 1 word) */
        unsigned int poll_mod   : 1;    /* mode polling or interrupt */
        unsigned int cpol       : 1;    /* SPI clock polarity */
        unsigned int cpha       : 1;    /* SPI clock phase */
        unsigned int dohie      : 1;    /* data output high impedance enable */
        unsigned int csiv       : 1;    /* csiv flag */
} qspi_dev;

extern void qspi_mutex_down(void);
extern void qspi_mutex_up(void);
extern qspi_dev *qspi_create_device(void);
extern int qspi_destroy_device(qspi_dev *device);
extern ssize_t qspi_internal_read(qspi_dev *dev,char *buffer, size_t length, loff_t *off,int qcr_cs);
extern ssize_t qspi_internal_write(qspi_dev *dev, const char *buffer, size_t length, loff_t *off,int qcr_cs);
extern int qspi_baud(int desired);

#endif  /* MCF_QSPI_H */
