/*
 * driver/usb/gadget/mcf532x_udc.h
 *
 * MCF532x USB Device Controller Driver Header file.
 *
 * Andrey Butok
 * Copyright Freescale Semiconductor, Inc. 2006
 */
#ifndef __MCF532X_UDC_H
#define __MCF532X_UDC_H

/* Register read/write macros */
#define MCF_USB0_ID			(*(volatile u32   *)(0xFC0B0000))
#define MCF_USB0_CAPLENGTH		(*(volatile u8    *)(0xFC0B0100))
#define MCF_USB0_HCIVERSION		(*(volatile u16   *)(0xFC0B0102))
#define MCF_USB0_HCSPARAMS		(*(volatile u32   *)(0xFC0B0104))
#define MCF_USB0_HCCPARAMS		(*(volatile u32   *)(0xFC0B0108))
#define MCF_USB0_DCIVERSION		(*(volatile u16   *)(0xFC0B0120))
#define MCF_USB0_DCCPARAMS		(*(volatile u32   *)(0xFC0B0124))
#define MCF_USB0_USBCMD			(*(volatile u32   *)(0xFC0B0140))
#define MCF_USB0_USBSTS			(*(volatile u32   *)(0xFC0B0144))
#define MCF_USB0_USBINTR		(*(volatile u32   *)(0xFC0B0148))
#define MCF_USB0_FRINDEX		(*(volatile u32   *)(0xFC0B014C))
#define MCF_USB0_PERIODICLISTBASE	(*(volatile u32   *)(0xFC0B0154))
#define MCF_USB0_DEVICEADDR		(*(volatile u32   *)(0xFC0B0154))
#define MCF_USB0_ASYNCLISTADDR		(*(volatile u32   *)(0xFC0B0158))
#define MCF_USB0_EPLISTADDR		(*(volatile u32   *)(0xFC0B0158))
#define MCF_USB0_ASNCTTSTS		(*(volatile u32   *)(0xFC0B015C))
#define MCF_USB0_BURSTSIZE		(*(volatile u32   *)(0xFC0B0160))
#define MCF_USB0_TXFILLTUNING		(*(volatile u32   *)(0xFC0B0164))
#define MCF_USB0_TXTTFILLTUNING		(*(volatile u32   *)(0xFC0B0168))
#define MCF_USB0_ULPI_VIEWPORT		(*(volatile u32   *)(0xFC0B0170))
#define MCF_USB0_CONFIGFLAG		(*(volatile u32   *)(0xFC0B0180))
#define MCF_USB0_PORTSC			(*(volatile u32   *)(0xFC0B0184))
#define MCF_USB0_OTGSC			(*(volatile u32   *)(0xFC0B01A4))
#define MCF_USB0_USBMODE		(*(volatile u32   *)(0xFC0B01A8))
#define MCF_USB0_EPSETUPSR		(*(volatile u32   *)(0xFC0B01AC))
#define MCF_USB0_EPPRIME		(*(volatile u32   *)(0xFC0B01B0))
#define MCF_USB0_EPFLUSH		(*(volatile u32   *)(0xFC0B01B4))
#define MCF_USB0_EPSR			(*(volatile u32   *)(0xFC0B01B8))
#define MCF_USB0_EPCOMPLETE		(*(volatile u32   *)(0xFC0B01BC))
#define MCF_USB0_EPCR0			(*(volatile u32   *)(0xFC0B01C0))
#define MCF_USB0_EPCR1			(*(volatile u32   *)(0xFC0B01C4))
#define MCF_USB0_EPCR2			(*(volatile u32   *)(0xFC0B01C8))
#define MCF_USB0_EPCR3			(*(volatile u32   *)(0xFC0B01CC))
#define MCF_USB0_EPCR(x)		(*(volatile u32   *)(0xFC0B01C0+((x)*0x004)))

/* Bit definitions and macros for MCF_USB_CAPLENGTH */
#define MCF_USB_CAPLENGTH_CAPLENGTH(x)		(((x)&0xFF)<<0)

/* Bit definitions and macros for MCF_USB_HCIVERSION */
#define MCF_USB_HCIVERSION_HCIVERSION(x)	(((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_USB_HCSPARAMS */
#define MCF_USB_HCSPARAMS_N_PORTS(x)		(((x)&0x0000000F)<<0)
#define MCF_USB_HCSPARAMS_PPC			(0x00000010)
#define MCF_USB_HCSPARAMS_N_PCC(x)		(((x)&0x0000000F)<<8)
#define MCF_USB_HCSPARAMS_N_CC(x)		(((x)&0x0000000F)<<12)
#define MCF_USB_HCSPARAMS_PI			(0x00010000)
#define MCF_USB_HCSPARAMS_N_PTT(x)		(((x)&0x0000000F)<<20)
#define MCF_USB_HCSPARAMS_N_TT(x)		(((x)&0x0000000F)<<24)

/* Bit definitions and macros for MCF_USB_HCCPARAMS */
#define MCF_USB_HCCPARAMS_ADC			(0x00000001)
#define MCF_USB_HCCPARAMS_PFL			(0x00000002)
#define MCF_USB_HCCPARAMS_ASP			(0x00000004)
#define MCF_USB_HCCPARAMS_IST(x)		(((x)&0x0000000F)<<4)
#define MCF_USB_HCCPARAMS_EECP(x)		(((x)&0x000000FF)<<8)

/* Bit definitions and macros for MCF_USB_DCIVERSION */
#define MCF_USB_DCIVERSION_DCIVERSION(x)	(((x)&0xFFFF)<<0)

/* Bit definitions and macros for MCF_USB_DCCPARAMS */
#define MCF_USB_DCCPARAMS_DEN(x)		(((x)&0x0000001F)<<0)
#define MCF_USB_DCCPARAMS_DC			(0x00000080)
#define MCF_USB_DCCPARAMS_HC			(0x00000100)

/* Bit definitions and macros for MCF_USB_USBCMD */
#define MCF_USB_USBCMD_RS			(0x00000001)
#define MCF_USB_USBCMD_RST			(0x00000002)
#define MCF_USB_USBCMD_FS0			(0x00000004)
#define MCF_USB_USBCMD_FS1			(0x00000008)
#define MCF_USB_USBCMD_PSE			(0x00000010)
#define MCF_USB_USBCMD_ASE			(0x00000020)
#define MCF_USB_USBCMD_IAA			(0x00000040)
#define MCF_USB_USBCMD_LR			(0x00000080)
#define MCF_USB_USBCMD_ASP(x)			(((x)&0x00000003)<<8)
#define MCF_USB_USBCMD_ASPE			(0x00000800)
#define MCF_USB_USBCMD_SUTW			(0x00002000)
#define MCF_USB_USBCMD_ATDTW			(0x00004000)
#define MCF_USB_USBCMD_FS2			(0x00008000)
#define MCF_USB_USBCMD_ITC(x)			(((x)&0x000000FF)<<16)
#define MCF_USB_USBCMD_ITC_IMM			(0x00000000)
#define MCF_USB_USBCMD_ITC_1			(0x00010000)
#define MCF_USB_USBCMD_ITC_2			(0x00020000)
#define MCF_USB_USBCMD_ITC_4			(0x00040000)
#define MCF_USB_USBCMD_ITC_8			(0x00080000)
#define MCF_USB_USBCMD_ITC_16			(0x00100000)
#define MCF_USB_USBCMD_ITC_32			(0x00200000)
#define MCF_USB_USBCMD_ITC_40			(0x00400000)
#define MCF_USB_USBCMD_FS_1024			(0x00000000)
#define MCF_USB_USBCMD_FS_512			(0x00000004)
#define MCF_USB_USBCMD_FS_256			(0x00000008)
#define MCF_USB_USBCMD_FS_128			(0x0000000C)
#define MCF_USB_USBCMD_FS_64			(0x00008000)
#define MCF_USB_USBCMD_FS_32			(0x00008004)
#define MCF_USB_USBCMD_FS_16			(0x00008008)
#define MCF_USB_USBCMD_FS_8			(0x0000800C)

/* Bit definitions and macros for MCF_USB_USBSTS */
#define MCF_USB_USBSTS_UI			(0x00000001)
#define MCF_USB_USBSTS_UEI			(0x00000002)
#define MCF_USB_USBSTS_PCI			(0x00000004)
#define MCF_USB_USBSTS_FRI			(0x00000008)
#define MCF_USB_USBSTS_SEI			(0x00000010)
#define MCF_USB_USBSTS_AAI			(0x00000020)
#define MCF_USB_USBSTS_URI			(0x00000040)
#define MCF_USB_USBSTS_SRI			(0x00000080)
#define MCF_USB_USBSTS_SLI			(0x00000100)
#define MCF_USB_USBSTS_HCH			(0x00001000)
#define MCF_USB_USBSTS_RCL			(0x00002000)
#define MCF_USB_USBSTS_PS			(0x00004000)
#define MCF_USB_USBSTS_AS			(0x00008000)

/* Bit definitions and macros for MCF_USB_USBINTR */
#define MCF_USB_USBINTR_UE			(0x00000001)
#define MCF_USB_USBINTR_UEE			(0x00000002)
#define MCF_USB_USBINTR_PCE			(0x00000004)
#define MCF_USB_USBINTR_FRE			(0x00000008)
#define MCF_USB_USBINTR_SEE			(0x00000010)
#define MCF_USB_USBINTR_AAE			(0x00000020)
#define MCF_USB_USBINTR_URE			(0x00000040)
#define MCF_USB_USBINTR_SRE			(0x00000080)
#define MCF_USB_USBINTR_SLE			(0x00000100)

/* Bit definitions and macros for MCF_USB_FRINDEX */
#define MCF_USB_FRINDEX_FRINDEX(x)		(((x)&0x00003FFF)<<0)

/* Bit definitions and macros for MCF_USB_PERIODICLISTBASE */
#define MCF_USB_PERIODICLISTBASE_PERBASE(x)	(((x)&0x000FFFFF)<<12)

/* Bit definitions and macros for MCF_USB_DEVICEADDR */
#define MCF_USB_DEVICEADDR_USBADR(x)		(((x)&0x0000007F)<<25)

/* Bit definitions and macros for MCF_USB_ASYNCLISTADDR */
#define MCF_USB_ASYNCLISTADDR_ASYBASE(x)	(((x)&0x07FFFFFF)<<5)

/* Bit definitions and macros for MCF_USB_EPLISTADDR */
#define MCF_USB_EPLISTADDR_EPBASE(x)		(((x)&0x001FFFFF)<<11)

/* Bit definitions and macros for MCF_USB_ASNCTTSTS */
#define MCF_USB_ASNCTTSTS_TTAS			(0x00000001)
#define MCF_USB_ASNCTTSTS_TTAC			(0x00000002)

/* Bit definitions and macros for MCF_USB_BURSTSIZE */
#define MCF_USB_BURSTSIZE_RXPBURST(x)		(((x)&0x000000FF)<<0)
#define MCF_USB_BURSTSIZE_TXPBURST(x)		(((x)&0x000000FF)<<8)

/* Bit definitions and macros for MCF_USB_TXFILLTUNING */
#define MCF_USB_TXFILLTUNING_TXSCHOH(x)		(((x)&0x000000FF)<<0)
#define MCF_USB_TXFILLTUNING_TXSCHHEALTH(x)	(((x)&0x0000001F)<<8)
#define MCF_USB_TXFILLTUNING_TXFIFOTHRES(x)	(((x)&0x0000003F)<<16)

/* Bit definitions and macros for MCF_USB_TXTTFILLTUNING */
#define MCF_USB_TXTTFILLTUNING_TXTTSCHOH(x)	(((x)&0x0000001F)<<0)
#define MCF_USB_TXTTFILLTUNING_TXTTSCHHEALTH(x)	(((x)&0x0000001F)<<8)

/* Bit definitions and macros for MCF_USB_ULPI_VIEWPORT */
#define MCF_USB_ULPI_VIEWPORT_ULPI_DATWR(x)	(((x)&0x000000FF)<<0)
#define MCF_USB_ULPI_VIEWPORT_ULPI_DATRD(x)	(((x)&0x000000FF)<<8)
#define MCF_USB_ULPI_VIEWPORT_ULPI_ADDR(x)	(((x)&0x000000FF)<<16)
#define MCF_USB_ULPI_VIEWPORT_ULPI_PORT(x)	(((x)&0x00000007)<<24)
#define MCF_USB_ULPI_VIEWPORT_ULPI_SS		(0x08000000)
#define MCF_USB_ULPI_VIEWPORT_ULPI_RW		(0x20000000)
#define MCF_USB_ULPI_VIEWPORT_ULPI_RUN		(0x40000000)
#define MCF_USB_ULPI_VIEWPORT_ULPI_WU		(0x80000000)

/* Bit definitions and macros for MCF_USB_CONFIGFLAG */
#define MCF_USB_CONFIGFLAG_CONFIGFLAG(x)	(((x)&0xFFFFFFFF)<<0)

/* Bit definitions and macros for MCF_USB_PORTSC */
#define MCF_USB_PORTSC_CCS			(0x00000001)
#define MCF_USB_PORTSC_CSC			(0x00000002)
#define MCF_USB_PORTSC_PE			(0x00000004)
#define MCF_USB_PORTSC_PEC			(0x00000008)
#define MCF_USB_PORTSC_OCA			(0x00000010)
#define MCF_USB_PORTSC_OCC			(0x00000020)
#define MCF_USB_PORTSC_FPR			(0x00000040)
#define MCF_USB_PORTSC_SUSP			(0x00000080)
#define MCF_USB_PORTSC_PR			(0x00000100)
#define MCF_USB_PORTSC_LS(x)			(((x)&0x00000003)<<10)
#define MCF_USB_PORTSC_PP			(0x00001000)
#define MCF_USB_PORTSC_PO			(0x00002000)
#define MCF_USB_PORTSC_PIC(x)			(((x)&0x00000003)<<14)
#define MCF_USB_PORTSC_PTC(x)			(((x)&0x0000000F)<<16)
#define MCF_USB_PORTSC_WLCN			(0x00100000)
#define MCF_USB_PORTSC_WKDS			(0x00200000)
#define MCF_USB_PORTSC_WKOC			(0x00400000)
#define MCF_USB_PORTSC_PHCD			(0x00800000)
#define MCF_USB_PORTSC_PFSC			(0x01000000)
#define MCF_USB_PORTSC_PTS(x)			(((x)&0x00000003)<<30)
#define MCF_USB_PORTSC_PTS_ULPI			(0x80000000)
#define MCF_USB_PORTSC_PTS_FS_LS		(0xC0000000)
#define MCF_USB_PORTSC_PSPD			(0x0C000000)
#define MCF_USB_PORTSC_PSPD_FULL		(0x00000000)
#define MCF_USB_PORTSC_PSPD_LOW			(0x04000000)
#define MCF_USB_PORTSC_PSPD_HIGH		(0x08000000)
#define MCF_USB_PORTSC_PTC_DISBALE		(0x00000000)
#define MCF_USB_PORTSC_PTC_JSTATE		(0x00010000)
#define MCF_USB_PORTSC_PTC_KSTATE		(0x00020000)
#define MCF_USB_PORTSC_PTC_SEQ_NAK		(0x00030000)
#define MCF_USB_PORTSC_PTC_PACKET		(0x00040000)
#define MCF_USB_PORTSC_PTC_FORCE_ENABLE		(0x00050000)
#define MCF_USB_PORTSC_PIC_OFF			(0x00000000)
#define MCF_USB_PORTSC_PIC_AMBER		(0x00004000)
#define MCF_USB_PORTSC_PIC_GREEN		(0x00008000)
#define MCF_USB_PORTSC_LS_SE0			(0x00000000)
#define MCF_USB_PORTSC_LS_JSTATE		(0x00000400)
#define MCF_USB_PORTSC_LS_KSTATE		(0x00000800)

/* Bit definitions and macros for MCF_USB_OTGSC */
#define MCF_USB_OTGSC_VD			(0x00000001)
#define MCF_USB_OTGSC_VC			(0x00000002)
#define MCF_USB_OTGSC_OT			(0x00000008)
#define MCF_USB_OTGSC_DP			(0x00000010)
#define MCF_USB_OTGSC_ID			(0x00000100)
#define MCF_USB_OTGSC_AVV			(0x00000200)
#define MCF_USB_OTGSC_ASV			(0x00000400)
#define MCF_USB_OTGSC_BSV			(0x00000800)
#define MCF_USB_OTGSC_BSE			(0x00001000)
#define MCF_USB_OTGSC_1MST			(0x00002000)
#define MCF_USB_OTGSC_DPS			(0x00004000)
#define MCF_USB_OTGSC_IDIS			(0x00010000)
#define MCF_USB_OTGSC_AVVIS			(0x00020000)
#define MCF_USB_OTGSC_ASVIS			(0x00040000)
#define MCF_USB_OTGSC_BSVIS			(0x00080000)
#define MCF_USB_OTGSC_BSEIS			(0x00100000)
#define MCF_USB_OTGSC_1MSS			(0x00200000)
#define MCF_USB_OTGSC_DPIS			(0x00400000)
#define MCF_USB_OTGSC_IDIE			(0x01000000)
#define MCF_USB_OTGSC_AVVIE			(0x02000000)
#define MCF_USB_OTGSC_ASVIE			(0x04000000)
#define MCF_USB_OTGSC_BSVIE			(0x08000000)
#define MCF_USB_OTGSC_BSEIE			(0x10000000)
#define MCF_USB_OTGSC_1MSE			(0x20000000)
#define MCF_USB_OTGSC_DPIE			(0x40000000)
#define MCF_USB_OTGSC_CLEAR			(0x007F0000)
#define MCF_USB_OTGSC_ENABLE_ALL		(0x7F000000)

/* Bit definitions and macros for MCF_USB_USBMODE */
#define MCF_USB_USBMODE_CM(x)			(((x)&0x00000003)<<0)
#define MCF_USB_USBMODE_SLOM			(0x00000008)
#define MCF_USB_USBMODE_SDIS			(0x00000010)
#define MCF_USB_USBMODE_CM_IDLE			(0x00000000)
#define MCF_USB_USBMODE_CM_DEVICE		(0x00000002)
#define MCF_USB_USBMODE_CM_HOST			(0x00000003)
#define MCF_USB_USBMODE_ES			(0x00000004)

/* Bit definitions and macros for MCF_USB_EPSETUPSR */
#define MCF_USB_EPSETUPSR_EPSETUPSTAT(x)	(((x)&0x000000F)<<0)

/* Bit definitions and macros for MCF_USB_EPPRIME */
#define MCF_USB_EPPRIME_PERB(x)			(((x)&0x000000F)<<0)
#define MCF_USB_EPPRIME_PETB(x)			(((x)&0x000000F)<<16)
#define MCF_USB_EPPRIME_PETB0			(0x00010000)
#define MCF_USB_EPPRIME_PETB1			(0x00020000)
#define MCF_USB_EPPRIME_PETB2			(0x00040000)
#define MCF_USB_EPPRIME_PETB3			(0x00080000)
#define MCF_USB_EPPRIME_PETB4			(0x00100000)
#define MCF_USB_EPPRIME_PETB5			(0x00200000)
#define MCF_USB_EPPRIME_PERB0			(0x00000001)
#define MCF_USB_EPPRIME_PERB1			(0x00000002)
#define MCF_USB_EPPRIME_PERB2			(0x00000004)
#define MCF_USB_EPPRIME_PERB3			(0x00000008)
#define MCF_USB_EPPRIME_PERB4			(0x00000010)
#define MCF_USB_EPPRIME_PERB5			(0x00000020)

/* Bit definitions and macros for MCF_USB_EPFLUSH */
#define MCF_USB_EPFLUSH_FERB(x)			(((x)&0x000000F)<<0)
#define MCF_USB_EPFLUSH_FETB(x)			(((x)&0x000000F)<<16)
#define MCF_USB_EPFLUSH_FETB0			(0x00010000)
#define MCF_USB_EPFLUSH_FETB1			(0x00020000)
#define MCF_USB_EPFLUSH_FETB2			(0x00040000)
#define MCF_USB_EPFLUSH_FETB3			(0x00080000)
#define MCF_USB_EPFLUSH_FETB4			(0x00100000)
#define MCF_USB_EPFLUSH_FETB5			(0x00200000)
#define MCF_USB_EPFLUSH_FERB0			(0x00000001)
#define MCF_USB_EPFLUSH_FERB1			(0x00000002)
#define MCF_USB_EPFLUSH_FERB2			(0x00000004)
#define MCF_USB_EPFLUSH_FERB3			(0x00000008)
#define MCF_USB_EPFLUSH_FERB4			(0x00000010)
#define MCF_USB_EPFLUSH_FERB5			(0x00000020)

/* Bit definitions and macros for MCF_USB_EPSR */
#define MCF_USB_EPSR_ERBR(x)			(((x)&0x0000003F)<<0)
#define MCF_USB_EPSR_ETBR(x)			(((x)&0x0000003F)<<16)
#define MCF_USB_EPSR_ETBR0			(0x00010000)
#define MCF_USB_EPSR_ETBR1			(0x00020000)
#define MCF_USB_EPSR_ETBR2			(0x00040000)
#define MCF_USB_EPSR_ETBR3			(0x00080000)
#define MCF_USB_EPSR_ETBR4			(0x00100000)
#define MCF_USB_EPSR_ETBR5			(0x00200000)
#define MCF_USB_EPSR_ERBR0			(0x00000001)
#define MCF_USB_EPSR_ERBR1			(0x00000002)
#define MCF_USB_EPSR_ERBR2			(0x00000004)
#define MCF_USB_EPSR_ERBR3			(0x00000008)
#define MCF_USB_EPSR_ERBR4			(0x00000010)
#define MCF_USB_EPSR_ERBR5			(0x00000020)

/* Bit definitions and macros for MCF_USB_EPCOMPLETE */
#define MCF_USB_EPCOMPLETE_ERCE(x)		(((x)&0x000000F)<<0)
#define MCF_USB_EPCOMPLETE_ETCE(x)		(((x)&0x000000F)<<16)
#define MCF_USB_EPCOMPLETE_ETCE0		(0x00010000)
#define MCF_USB_EPCOMPLETE_ETCE1		(0x00020000)
#define MCF_USB_EPCOMPLETE_ETCE2		(0x00040000)
#define MCF_USB_EPCOMPLETE_ETCE3		(0x00080000)

#define MCF_USB_EPCOMPLETE_ERCE0		(0x00000001)
#define MCF_USB_EPCOMPLETE_ERCE1		(0x00000002)
#define MCF_USB_EPCOMPLETE_ERCE2		(0x00000004)
#define MCF_USB_EPCOMPLETE_ERCE3		(0x00000008)

/* Bit definitions and macros for MCF_USB_EPCR0 */
#define MCF_USB_EPCR0_RXS			(0x00000001)
#define MCF_USB_EPCR0_RXT(x)			(((x)&0x00000003)<<2)
#define MCF_USB_EPCR0_RXE			(0x00000080)
#define MCF_USB_EPCR0_TXS			(0x00010000)
#define MCF_USB_EPCR0_TXT(x)			(((x)&0x00000003)<<18)
#define MCF_USB_EPCR0_TXE			(0x00800000)

/* Bit definitions and macros for MCF_USB_EPCR */
#define MCF_USB_EPCR_RXS			(0x00000001)
#define MCF_USB_EPCR_RXD			(0x00000002)
#define MCF_USB_EPCR_RXT(x)			(((x)&0x00000003)<<2)
#define MCF_USB_EPCR_RXI			(0x00000020)
#define MCF_USB_EPCR_RXR			(0x00000040)
#define MCF_USB_EPCR_RXE			(0x00000080)
#define MCF_USB_EPCR_TXS			(0x00010000)
#define MCF_USB_EPCR_TXD			(0x00020000)
#define MCF_USB_EPCR_TXT(x)			(((x)&0x00000003)<<18)
#define MCF_USB_EPCR_TXI			(0x00200000)
#define MCF_USB_EPCR_TXR			(0x00400000)
#define MCF_USB_EPCR_TXE			(0x00800000)
#define MCF_USB_EPCR_TXT_CONTROL		(0x00000000)
#define MCF_USB_EPCR_TXT_ISO			(0x00040000)
#define MCF_USB_EPCR_TXT_BULK			(0x00080000)
#define MCF_USB_EPCR_TXT_INT			(0x000C0000)
#define MCF_USB_EPCR_RXT_CONTROL		(0x00000000)
#define MCF_USB_EPCR_RXT_ISO			(0x00000004)
#define MCF_USB_EPCR_RXT_BULK			(0x00000008)
#define MCF_USB_EPCR_RXT_INT			(0x0000000C)

/********************************************************************/

#define USB_MAX_ENDPOINTS		(4)
#define USB_MAX_PIPES			(USB_MAX_ENDPOINTS*2)
#define USB_MAX_CTRL_PAYLOAD		(64)

/* ep0 transfer state */
#define WAIT_FOR_SETUP			(0)
#define DATA_STATE_XMIT			(1)
#define DATA_STATE_NEED_ZLP		(2)
#define WAIT_FOR_OUT_STATUS		(3)
#define DATA_STATE_RECV			(4)

/* Endpoint Queue Head data struct
 */
struct ep_queue_head {
	volatile u32 max_pkt_length;	/* Mult(31-30) , Zlt(29) , Max Pkt len
					   and IOS(15) */
	volatile u32 curr_dtd_ptr;	/* Current dTD Pointer(31-5) */
	volatile u32 next_dtd_ptr;	/* Next dTD Pointer(31-5), T(0) */
	volatile u32 size_ioc_int_sts;	/* Total bytes (30-16), IOC (15),
					   MultO(11-10), STS (7-0)  */
	volatile u32 buff_ptr0;	/* Buffer pointer Page 0 (31-12) */
	volatile u32 buff_ptr1;	/* Buffer pointer Page 1 (31-12) */
	volatile u32 buff_ptr2;	/* Buffer pointer Page 2 (31-12) */
	volatile u32 buff_ptr3;	/* Buffer pointer Page 3 (31-12) */
	volatile u32 buff_ptr4;	/* Buffer pointer Page 4 (31-12) */
	volatile u32 res1;
	volatile u32 setup_buffer[2];	/* Setup data 8 bytes */
	volatile u32 res2[4];
} __attribute__ ((packed));

/* Endpoint Queue Head Bit Masks */
#define EP_QUEUE_HEAD_MULT_POS			(30)
#define EP_QUEUE_HEAD_ZLT_SEL			(0x20000000)
#define EP_QUEUE_HEAD_MAX_PKT_LEN_POS		(16)
#define EP_QUEUE_HEAD_MAX_PKT_LEN(ep_info)	(((ep_info)>>16)&0x07ff)
#define EP_QUEUE_HEAD_IOS			(0x00008000)
#define EP_QUEUE_HEAD_NEXT_TERMINATE		(0x00000001)
#define EP_QUEUE_HEAD_IOC			(0x00008000)
#define EP_QUEUE_HEAD_MULTO			(0x00000C00)
#define EP_QUEUE_HEAD_STATUS_HALT		(0x00000040)
#define EP_QUEUE_HEAD_STATUS_ACTIVE		(0x00000080)
#define EP_QUEUE_CURRENT_OFFSET_MASK		(0x00000FFF)
#define EP_QUEUE_HEAD_NEXT_POINTER_MASK		(0xFFFFFFE0)
#define EP_QUEUE_FRINDEX_MASK			(0x000007FF)
#define EP_MAX_LENGTH_TRANSFER			(0x4000)

/* Endpoint Transfer Descriptor data struct */
struct ep_td_struct {
	volatile u32 next_td_ptr;	/* Next TD pointer(31-5), T(0) set
					   indicate invalid */
	volatile u32 size_ioc_sts;	/* Total bytes (30-16), IOC (15),
					   MultO(11-10), STS (7-0)  */
	volatile u32 buff_ptr0;	/* Buffer pointer Page 0 */
	volatile u32 buff_ptr1;	/* Buffer pointer Page 1 */
	volatile u32 buff_ptr2;	/* Buffer pointer Page 2 */
	volatile u32 buff_ptr3;	/* Buffer pointer Page 3 */
	volatile u32 buff_ptr4;	/* Buffer pointer Page 4 */
} __attribute__ ((packed));

/* Endpoint Transfer Descriptor bit Masks */
#define DTD_NEXT_TERMINATE		(0x00000001)
#define DTD_IOC				(0x00008000)
#define DTD_STATUS_ACTIVE		(0x00000080)
#define DTD_STATUS_HALTED		(0x00000040)
#define DTD_STATUS_DATA_BUFF_ERR	(0x00000020)
#define DTD_STATUS_TRANSACTION_ERR	(0x00000008)
#define DTD_RESERVED_FIELDS		(0x80007300)
#define DTD_ADDR_MASK			(0xFFFFFFE0)
#define DTD_PACKET_SIZE			(0x7FFF0000)
#define DTD_LENGTH_BIT_POS		(16)
#define DTD_ERROR_MASK			(DTD_STATUS_HALTED | \
					DTD_STATUS_DATA_BUFF_ERR | \
					DTD_STATUS_TRANSACTION_ERR)

/*-------------------------------------------------------------------------*/

/* Driver private data.
 */
struct mcf532x_req {
	struct usb_request req;
	struct list_head queue;
	/* ep_queue() func will add 
	   a request->queue into a udc_ep->queue 'd tail */
	struct mcf532x_ep *ep;
	unsigned mapped:1;

	struct ep_td_struct *head, *tail;
	unsigned int dtd_count;
};

#define REQ_UNCOMPLETE		(1)

struct mcf532x_ep {
	struct usb_ep ep;
	struct list_head queue;
	struct mcf532x_udc *udc;
	const struct usb_endpoint_descriptor *desc;
	struct usb_gadget *gadget;

	char name[14];
	unsigned stopped:1;
};

#define EP_DIR_IN	1
#define EP_DIR_OUT	0

struct mcf532x_udc {
	struct usb_gadget gadget;
	struct usb_gadget_driver *driver;
	struct mcf532x_ep eps[USB_MAX_ENDPOINTS * 2];
	struct usb_ctrlrequest local_setup_buff;
	spinlock_t lock;

	struct otg_transceiver *transceiver;

	struct ep_queue_head *ep_qh;	/* Endpoints Queue-Head */
	struct mcf532x_req *status_req;	/* ep0 status request */

	u32 max_pipes;		/* Device max pipes */
	u32 max_use_endpts;	/* Max endpointes to be used */
	u32 bus_reset;		/* Device is bus reseting */
	u32 resume_state;	/* USB state to resume */
	u32 usb_state;		/* USB current state */
	u32 usb_next_state;	/* USB next state */
	u32 ep0_state;		/* Enpoint zero state */
	u32 ep0_dir;		/* Enpoint zero direction: can be
				   USB_DIR_IN or USB_DIR_OUT */
	u32 usb_sof_count;	/* SOF count */
	u32 errors;		/* USB ERRORs count */
	u8 device_address;	/* Device USB address */

	struct completion *done;	/* to make sure release() is done */
	int irq;
	unsigned softconnect:1;
	unsigned vbus_active:1;
	unsigned selfpowered:1;
	unsigned wakeup_enabled:1;
	unsigned stopped:1;
};

/*-------------------------------------------------------------------------*/

#ifdef DEBUG
#define DBG(fmt, args...) 	printk("[%s]  " fmt "\n", \
				__FUNCTION__, ## args)
#else
#define DBG(fmt, args...)	do{}while(0)
#endif

#ifdef VERBOSE
#    define VDBG		DBG
#else
#    define VDBG(stuff...)	do{}while(0)
#endif

#define ERR(stuff...)		printk(KERN_ERR "udc: " stuff)
#define WARN(stuff...)		printk(KERN_WARNING "udc: " stuff)
#define INFO(stuff...)		printk(KERN_INFO "udc: " stuff)

/*-------------------------------------------------------------------------*/

/*
 * Pipe direction macro from device view
 */
#define USB_RECV	(0)	/* OUT EP */
#define USB_SEND	(1)	/* IN EP */

/*
 * Internal used help routines.
 */
#define ep_index(EP)		((EP)->desc->bEndpointAddress&0xF)
#define ep_maxpacket(EP)	((EP)->ep.maxpacket)
#define ep_is_in(EP)	( (ep_index(EP) == 0) ? (EP->udc->ep0_dir == \
			USB_DIR_IN ):((EP)->desc->bEndpointAddress \
			& USB_DIR_IN)==USB_DIR_IN)
#define get_ep_by_pipe(udc, pipe)	((pipe == 1)? &udc->eps[0]: \
					&udc->eps[pipe])
/*
 * memory kmalloc with alignning size and zero the content
 * @base :output parameter. It store the base address before align. 
 * Return value it the address after align
 *
 */
static void *
KMALLOC_ALIGN(size_t size, int flags, unsigned int align, void **base)
{
	*base = kmalloc(size + align, flags);
	if (*base == NULL)
		return NULL;
	memset(*base, 0, (size + align));
	return (void *) ALIGN((unsigned int) (*base), align);
}

#endif
