/****************************************************************************/

/*
 *	m5253sim.h -- ColdFire 5253 System Integration Module support.
 *
 *	Matt Waddel matt.waddel@freescale.com
 *	Copyright Freescale Semiconductor, Inc. 2006
 *
 *	Based on the m5249c3 software.
 *	(C) Copyright 2002, Greg Ungerer (gerg@snapgear.com)
 */

/****************************************************************************/
#ifndef	m5253sim_h
#define	m5253sim_h
/****************************************************************************/

#define MCF_REG32(x) (*(volatile unsigned long  *)(x))
#define MCF_REG16(x) (*(volatile unsigned short *)(x))
#define MCF_REG08(x) (*(volatile unsigned char  *)(x))

/*
 *	Define the 5253 SIM register set addresses.
 */
#define	MCFSIM_RSR		0x00		/* Reset Status reg (r/w) */
#define	MCFSIM_SYPCR		0x01		/* System Protection reg (r/w)*/
#define	MCFSIM_SWIVR		0x02		/* SW Watchdog intr reg (r/w) */
#define	MCFSIM_SWSR		0x03		/* SW Watchdog service (r/w) */
#define	MCFSIM_PAR		0x04		/* Pin Assignment reg (r/w) */
#define	MCFSIM_IRQPAR		0x06		/* Interrupt Assignment reg (r/w) */
#define	MCFSIM_MPARK		0x0C		/* BUS Master Control Reg*/
#define	MCFSIM_IPR		0x40		/* Interrupt Pend reg (r/w) */
#define	MCFSIM_IMR		0x44		/* Interrupt Mask reg (r/w) */
#define	MCFSIM_AVR		0x4b		/* Autovector Ctrl reg (r/w) */
#define	MCFSIM_ICR0		0x4c		/* Intr Ctrl reg 0 (r/w) */
#define	MCFSIM_ICR1		0x4d		/* Intr Ctrl reg 1 (r/w) */
#define	MCFSIM_ICR2		0x4e		/* Intr Ctrl reg 2 (r/w) */
#define	MCFSIM_ICR3		0x4f		/* Intr Ctrl reg 3 (r/w) */
#define	MCFSIM_ICR4		0x50		/* Intr Ctrl reg 4 (r/w) */
#define	MCFSIM_ICR5		0x51		/* Intr Ctrl reg 5 (r/w) */
#define	MCFSIM_ICR6		0x52		/* Intr Ctrl reg 6 (r/w) */
#define	MCFSIM_ICR7		0x53		/* Intr Ctrl reg 7 (r/w) */
#define	MCFSIM_ICR8		0x54		/* Intr Ctrl reg 8 (r/w) */
#define	MCFSIM_ICR9		0x55		/* Intr Ctrl reg 9 (r/w) */
#define	MCFSIM_ICR10		0x56		/* Intr Ctrl reg 10 (r/w) */
#define	MCFSIM_ICR11		0x57		/* Intr Ctrl reg 11 (r/w) */

#define MCFSIM_CSAR0		0x80		/* CS 0 Address 0 reg (r/w) */
#define MCFSIM_CSMR0		0x84		/* CS 0 Mask 0 reg (r/w) */
#define MCFSIM_CSCR0		0x8a		/* CS 0 Control reg (r/w) */
#define MCFSIM_CSAR1		0x8c		/* CS 1 Address reg (r/w) */
#define MCFSIM_CSMR1		0x90		/* CS 1 Mask reg (r/w) */
#define MCFSIM_CSCR1		0x96		/* CS 1 Control reg (r/w) */
#define MCFSIM_CSAR2		0x98		/* CS 2 Adress reg (r/w) */
#define MCFSIM_CSMR2		0x9c		/* CS 2 Mask reg (r/w) */
#define MCFSIM_CSCR2		0xa2		/* CS 2 Control reg (r/w) */
#define MCFSIM_CSAR3		0xa4		/* CS 3 Adress reg (r/w) */
#define MCFSIM_CSMR3		0xa8		/* CS 3 Mask reg (r/w) */
#define MCFSIM_CSCR3		0xae		/* CS 3 Control reg (r/w) */

#define MCFSIM_DCR		0x100		/* DRAM Control reg (r/w) */
#define MCFSIM_DACR0		0x108		/* DRAM 0 Addr and Ctrl (r/w) */
#define MCFSIM_DMR0		0x10c		/* DRAM 0 Mask reg (r/w) */


/*
 *	Some symbol defines for the above...
 */
#define	MCFSIM_SWDICR		MCFSIM_ICR0	/* Watchdog timer ICR */
#define	MCFSIM_TIMER1ICR	MCFSIM_ICR1	/* Timer 1 ICR */
#define	MCFSIM_TIMER2ICR	MCFSIM_ICR2	/* Timer 2 ICR */
#define	MCFSIM_UART1ICR		MCFSIM_ICR4	/* UART 1 ICR */
#define	MCFSIM_UART2ICR		MCFSIM_ICR5	/* UART 2 ICR */
#define	MCFSIM_DMA0ICR		MCFSIM_ICR6	/* DMA 0 ICR */
#define	MCFSIM_DMA1ICR		MCFSIM_ICR7	/* DMA 1 ICR */
#define	MCFSIM_DMA2ICR		MCFSIM_ICR8	/* DMA 2 ICR */
#define	MCFSIM_DMA3ICR		MCFSIM_ICR9	/* DMA 3 ICR */

/*
 *	General purpose IO registers (in MBAR2).
 */
#define	MCFSIM2_GPIOREAD	0x0		/* GPIO read values */
#define	MCFSIM2_GPIOWRITE	0x4		/* GPIO write values */
#define	MCFSIM2_GPIOENABLE	0x8		/* GPIO enabled */
#define	MCFSIM2_GPIOFUNC	0xc		/* GPIO function */
#define	MCFSIM2_GPIO1READ	0xb0		/* GPIO1 read values */
#define	MCFSIM2_GPIO1WRITE	0xb4		/* GPIO1 write values */
#define	MCFSIM2_GPIO1ENABLE	0xb8		/* GPIO1 enabled */
#define	MCFSIM2_GPIO1FUNC	0xbc		/* GPIO1 function */

#define	MCFSIM2_GPIOINTSTAT	0xc0		/* GPIO interrupt status */
#define	MCFSIM2_GPIOINTCLEAR	0xc0		/* GPIO interrupt clear */
#define	MCFSIM2_GPIOINTENABLE	0xc4		/* GPIO interrupt enable */

#define	MCFSIM2_INTLEVEL1	0x140		/* Interrupt level reg 1 */
#define	MCFSIM2_INTLEVEL2	0x144		/* Interrupt level reg 2 */
#define	MCFSIM2_INTLEVEL3	0x148		/* Interrupt level reg 3 */
#define	MCFSIM2_INTLEVEL4	0x14c		/* Interrupt level reg 4 */
#define	MCFSIM2_INTLEVEL5	0x150		/* Interrupt level reg 5 */
#define	MCFSIM2_INTLEVEL6	0x154		/* Interrupt level reg 6 */
#define	MCFSIM2_INTLEVEL7	0x158		/* Interrupt level reg 7 */
#define	MCFSIM2_INTLEVEL8	0x15c		/* Interrupt level reg 8 */

#define	MCFSIM2_DMAROUTE	0x188		/* DMA routing */

#define	MCFSIM2_IDECONFIG1	0x18c		/* IDEconfig1 */
#define	MCFSIM2_IDECONFIG2	0x190		/* IDEconfig2 */

/*
 *      Real-Time clock defines
 */
#define MCF_RTC_MISC		MCF_REG32(MCF_MBAR2+0x500)	/* RTC misc */
#define MCF_RTC_TIME		MCF_REG32(MCF_MBAR2+0x50c)	/* RTC time */

/* Real-Time Clock Miscellaneous Configuration Register */
#define MCF_RTC_MISC_RTCPL	0x00000100	/* Real-time clock power loss */
#define MCF_RTC_MISC_RTCCLR	0x00000080	/* Real-time clock power loss clear */

/*
 *      Interrupt defines
 */
#define MCFINT_VECBASE		128		/* Interrupt vector base */
#define MCFINT_UART0		26		/* Interrupt number for UART0 */
#define MCFINT_UART1		27		/* Interrupt number for UART1 */
#define MCFINT_QSPI		32		/* Interrupt number for QSPI */

/*
 *	Macro to set IMR register. It is 32 bits on the 5253.
 */
#define	MCFSIM_IMR_MASKALL	0x7fffe		/* All SIM intr sources */

#define	mcf_getimr()		\
	*((volatile unsigned long *) (MCF_MBAR + MCFSIM_IMR))

#define	mcf_setimr(imr)		\
	*((volatile unsigned long *) (MCF_MBAR + MCFSIM_IMR)) = (imr);

#define	mcf_getipr()		\
	*((volatile unsigned long *) (MCF_MBAR + MCFSIM_IPR))

/*
 *	I2C register definitions
 */
#define MCF_I2C_I2ADR	(volatile u8  *)(MCF_MBAR + 0x280)
#define MCF_I2C_I2FDR	(volatile u8  *)(MCF_MBAR + 0x284)
#define MCF_I2C_I2CR	(volatile u8  *)(MCF_MBAR + 0x288)
#define MCF_I2C_I2SR	(volatile u8  *)(MCF_MBAR + 0x28C)
#define MCF_I2C_I2DR	(volatile u8  *)(MCF_MBAR + 0x290)
#define MCF_I2C2_I2ADR	(volatile u8  *)(MCF_MBAR2 + 0x440)
#define MCF_I2C2_I2FDR	(volatile u8  *)(MCF_MBAR2 + 0x444)
#define MCF_I2C2_I2CR	(volatile u8  *)(MCF_MBAR2 + 0x448)
#define MCF_I2C2_I2SR	(volatile u8  *)(MCF_MBAR2 + 0x44C)
#define MCF_I2C2_I2DR	(volatile u8  *)(MCF_MBAR2 + 0x450)

/*
 *	Interrupt Controller 2 register definitions
 */
#define MCF_INTC1_INTPRI(x) 		MCF_REG32(MCF_MBAR2+0x140+(x)*4)
#define MCF_INTC1_INTBASE		MCF_REG08(MCF_MBAR2+0x16B)
#define MCF_INTC1_SPURVEC		MCF_REG08(MCF_MBAR2+0x167)


/*********************************************************************
 *
 *      FlexCAN module registers
 *
 *********************************************************************/
#define MCF_FLEXCAN_BASEADDR(x)		(MCF_MBAR2+(x+1)*0x1000)
#define MCF_FLEXCAN_CANMCR(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x00)
#define MCF_FLEXCAN_CANCTRL(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x04)
#define MCF_FLEXCAN_TIMER(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x08)
#define MCF_FLEXCAN_RXGMASK(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x10)
#define MCF_FLEXCAN_RX14MASK(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x14)
#define MCF_FLEXCAN_RX15MASK(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x18)
#define MCF_FLEXCAN_ERRCNT(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x1C)
#define MCF_FLEXCAN_ERRSTAT(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x20)
#define MCF_FLEXCAN_IMASK(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x28)
#define MCF_FLEXCAN_IFLAG(x)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x30)

#define MCF_FLEXCAN_MB_CNT(x,y)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x80+(y)*0x10+0x0)
#define MCF_FLEXCAN_MB_ID(x,y)		MCF_REG32(MCF_MBAR2+(x+1)*0x1000+0x80+(y)*0x10+0x4)
#define MCF_FLEXCAN_MB_DB(x,y,z)	MCF_REG08(MCF_MBAR2+(x+1)*0x1000+0x80+(y)*0x10+0x8+(z)*0x1)

/*
 *      FlexCAN Module Configuration Register
 */
#define CANMCR_MDIS		(0x80000000)
#define CANMCR_FRZ		(0x40000000)
#define CANMCR_HALT		(0x10000000)
#define CANMCR_SOFTRST		(0x02000000)
#define CANMCR_FRZACK		(0x01000000)
#define CANMCR_SUPV		(0x00800000)
#define CANMCR_MAXMB(x)         ((x)&0x0F)

/*
 *      FlexCAN Control Register
 */
#define CANCTRL_PRESDIV(x)      (((x)&0xFF)<<24)
#define CANCTRL_RJW(x)          (((x)&0x03)<<22)
#define CANCTRL_PSEG1(x)        (((x)&0x07)<<19)
#define CANCTRL_PSEG2(x)        (((x)&0x07)<<16)
#define CANCTRL_BOFFMSK         (0x00008000)
#define CANCTRL_ERRMSK	        (0x00004000)
#define CANCTRL_CLKSRC		(0x00002000)
#define CANCTRL_LPB	        (0x00001000)
#define CANCTRL_SAMP	        (0x00000080)
#define CANCTRL_BOFFREC         (0x00000040)
#define CANCTRL_TSYNC           (0x00000020)
#define CANCTRL_LBUF            (0x00000010)
#define CANCTRL_LOM             (0x00000008)
#define CANCTRL_PROPSEG(x)      ((x)&0x07)

/*
 *      FlexCAN Error Counter Register
 */
#define ERRCNT_RXECTR(x)        (((x)&0xFF)<<8)
#define ERRCNT_TXECTR(x)        ((x)&0xFF)

/*
 *      FlexCAN Error and Status Register
 */
#define ERRSTAT_BITERR(x)       (((x)&0x03)<<14)
#define ERRSTAT_ACKERR           (0x00002000)
#define ERRSTAT_CRCERR           (0x00001000)
#define ERRSTAT_FRMERR           (0x00000800)
#define ERRSTAT_STFERR           (0x00000400)
#define ERRSTAT_TXWRN            (0x00000200)
#define ERRSTAT_RXWRN            (0x00000100)
#define ERRSTAT_IDLE             (0x00000080)
#define ERRSTAT_TXRX             (0x00000040)
#define ERRSTAT_FLTCONF(x)       (((x)&0x03)<<4)
#define ERRSTAT_BOFFINT          (0x00000004)
#define ERRSTAT_ERRINT           (0x00000002)

/*
 *      Interrupt Mask Register
 */
#define IMASK_BUF15M		(0x8000)
#define IMASK_BUF14M		(0x4000)
#define IMASK_BUF13M		(0x2000)
#define IMASK_BUF12M		(0x1000)
#define IMASK_BUF11M		(0x0800)
#define IMASK_BUF10M		(0x0400)
#define IMASK_BUF9M		(0x0200)
#define IMASK_BUF8M		(0x0100)
#define IMASK_BUF7M		(0x0080)
#define IMASK_BUF6M		(0x0040)
#define IMASK_BUF5M		(0x0020)
#define IMASK_BUF4M		(0x0010)
#define IMASK_BUF3M		(0x0008)
#define IMASK_BUF2M		(0x0004)
#define IMASK_BUF1M		(0x0002)
#define IMASK_BUF0M		(0x0001)
#define IMASK_BUFnM(x)		(0x1<<(x))
#define IMASK_BUFF_ENABLE_ALL	(0x1111)
#define IMASK_BUFF_DISABLE_ALL	(0x0000)

/*
 *      Interrupt Flag Register
 */
#define IFLAG_BUF15M		(0x8000)
#define IFLAG_BUF14M		(0x4000)
#define IFLAG_BUF13M		(0x2000)
#define IFLAG_BUF12M		(0x1000)
#define IFLAG_BUF11M		(0x0800)
#define IFLAG_BUF10M		(0x0400)
#define IFLAG_BUF9M		(0x0200)
#define IFLAG_BUF8M		(0x0100)
#define IFLAG_BUF7M		(0x0080)
#define IFLAG_BUF6M		(0x0040)
#define IFLAG_BUF5M		(0x0020)
#define IFLAG_BUF4M		(0x0010)
#define IFLAG_BUF3M		(0x0008)
#define IFLAG_BUF2M		(0x0004)
#define IFLAG_BUF1M		(0x0002)
#define IFLAG_BUF0M		(0x0001)
#define IFLAG_BUFF_SET_ALL	(0xFFFF)
#define IFLAG_BUFF_CLEAR_ALL	(0x0000)
#define IFLAG_BUFnM(x)		(0x1<<(x))

/*
 *      Message Buffers
 */
#define MB_CNT_CODE(x)		(((x)&0x0F)<<24)
#define MB_CNT_SRR		(0x00400000)
#define MB_CNT_IDE		(0x00200000)
#define MB_CNT_RTR		(0x00100000)
#define MB_CNT_LENGTH(x)	(((x)&0x0F)<<16)
#define MB_CNT_TIMESTAMP(x)	((x)&0xFFFF)
#define MB_ID_STD(x)		(((x)&0x07FF)<<18)
#define MB_ID_EXT(x)		((x)&0x3FFFF)

	
/****************************************************************************/

#ifdef __ASSEMBLER__

/*
 *	The M5253EVB board needs a little help getting all its SIM devices
 *	initialized at kernel start time. dBUG doesn't set much up, so
 *	we need to do it manually.
 */
.macro m5253evb_setup
	/*
	 *	Set MBAR1 and MBAR2, just in case they are not set.
	 */
	movel	#0x10000001,%a0
	movec	%a0,%MBAR			/* map MBAR region */
	subql	#1,%a0				/* get MBAR address in a0 */

	movel	#0x80000001,%a1
	movec	%a1,#0xC0E			/* map MBAR2 region */
	subql	#1,%a1				/* get MBAR2 address in a1 */

#if CONFIG_CLOCK_FREQ == 140000000
	/*
	 *	Set initial clock frequency. This assumes M5253EVB board
	 *	is fitted with 11.2896MHz crystal. It will program the
	 *	PLL for 140MHz. Lets go fast :-)
	 */
	movel	#0x1243E055,%d0			/* set for 140MHz */
	movel	%d0,0x180(%a1)			/* set PLL register */
#endif

.endm

#define	PLATFORM_SETUP	m5253evb_setup

#endif /* __ASSEMBLER__ */

/****************************************************************************/
#endif	/* m5253sim_h */
