/***************************************************************************/
/*                  Copyright (c) 2007 Dark Matter Digital Inc             */
/***************************************************************************/

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// See <http://www.gnu.org/copyleft/lesser.html>
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

/////////////////////////////////////////////////////////////////////

#ifndef __AVAHI_HELPER_INCLUDED__
#define __AVAHI_HELPER_INCLUDED__

/////////////////////////////////////////////////////////////////////

#define SOCKET_AVAHI_NAME	"/tmp/avahi_socket"

/////////////////////////////////////////////////////////////////////

typedef struct {
	int		MessageComplete;	/* Used to indicate message completion */
	int 		MessageResult;		/* Used to return status code upon completion */
	const char	*UnitTypeName;		
	const char	*UnitUserName;		/* May be NULL */
	const char 	*ServiceType;
	unsigned short	ServicePort;
	const char	*TextRecordLocalMAC;	/* Text record with local ethernet address info */
	const char	*TextRecordHost;	/* Text record with host info */
	const char	*TextRecordHostMAC;	/* Text record with host ethernet address  info */
} AVAHI_HELPER_SHARED;

/////////////////////////////////////////////////////////////////////

enum {
	MSG_AVAHI_INIT,
	MSG_AVAHI_CLOSE,
	MSG_AVAHI_SERVICE,
	MSG_AVAHI_RESET,
	MSG_AVAHI_UPDATE_RECORDS
};

typedef struct {
	unsigned char	Type;
	unsigned int	Length;
} AVAHI_MSG_HDR;

typedef struct {
	AVAHI_MSG_HDR		Header;		// MSG_AVAHI_INIT
	AVAHI_HELPER_SHARED	*pSharedContext;
} AVAHI_MSG_INIT;

typedef struct {
	AVAHI_MSG_HDR		Header;		// MSG_AVAHI_CLOSE
} AVAHI_MSG_CLOSE;

typedef struct {
	AVAHI_MSG_HDR		Header;		// MSG_AVAHI_SERVICE
	unsigned int		Timeout;
} AVAHI_MSG_SERVICE;

typedef struct {
	AVAHI_MSG_HDR		Header;		// MSG_AVAHI_RESET
} AVAHI_MSG_RESET;

typedef struct {
	AVAHI_MSG_HDR		Header;		// MSG_AVAHI_UPDATE_RECORDS
} AVAHI_MSG_UPDATE;

#endif	//__AVAHI_HELPER_INCLUDED__
