/***************************************************************************/

/*
 *  linux/arch/m68knommu/platform/5253/config.c
 *      (Based on mcf5249 code)
 *
 *  Copyright (C) 1999-2003, Greg Ungerer (gerg@snapgear.com)
 *
 *  Matt Waddel matt.waddel@freescale.com
 *  Copyright Freescale Semiconductor, Inc. 2006
 */

/***************************************************************************/

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <asm/machdep.h>
#include <asm/dma.h>
#include <asm/irq.h>
#include <asm/dma.h>
#include <asm/traps.h>
#include <asm/machdep.h>
#include <asm/coldfire.h>
#include <asm/mcftimer.h>
#include <asm/mcfsim.h>
#include <linux/rtc.h>

/***************************************************************************/

/*
 *	DMA channel base address table.
 */
unsigned int dma_base_addr[MAX_M68K_DMA_CHANNELS] ={
	MCF_MBAR + MCFDMA_BASE0,
	MCF_MBAR + MCFDMA_BASE1,
	MCF_MBAR + MCFDMA_BASE2,
	MCF_MBAR + MCFDMA_BASE3,
};
unsigned int dma_device_address[MAX_M68K_DMA_CHANNELS];

/***************************************************************************/

void coldfire_tick(void);
void coldfire_timer_init(irqreturn_t (*handler)(int, void *, struct pt_regs *));
unsigned long coldfire_timer_offset(void);
void coldfire_trap_init(void);
void coldfire_reset(void);

/***************************************************************************/

/*
 *  Program the vector to be an auto-vectored.
 */
void mcf_autovector(unsigned int vec)
{
	volatile unsigned char  *mbar;

	if ((vec >= 25) && (vec <= 31)) {
		mbar = (volatile unsigned char *) MCF_MBAR;
		vec = 0x1 << (vec - 24);
		*(mbar + MCFSIM_AVR) |= vec;
		mcf_setimr(mcf_getimr() & ~vec);
	}
}

/***************************************************************************/

void mcf_settimericr(unsigned int timer, unsigned int level)
{
	volatile unsigned char *icrp;
	unsigned int icr, imr;

	if (timer <= 2) {
		switch (timer) {
		case 2:  icr = MCFSIM_TIMER2ICR; imr = MCFSIM_IMR_TIMER2; break;
		default: icr = MCFSIM_TIMER1ICR; imr = MCFSIM_IMR_TIMER1; break;
		}

		icrp = (volatile unsigned char *) (MCF_MBAR + icr);
		*icrp = MCFSIM_ICR_AUTOVEC | (level << 2) | MCFSIM_ICR_PRI3;
		mcf_setimr(mcf_getimr() & ~imr);
	}
}

/***************************************************************************/

int mcf_timerirqpending(int timer)
{
	unsigned int imr = 0;

	switch (timer) {
	case 1:  imr = MCFSIM_IMR_TIMER1; break;
	case 2:  imr = MCFSIM_IMR_TIMER2; break;
	default: break;
	}
	return (mcf_getipr() & imr);
}

#if defined(CONFIG_RTC_CLASS)
#include <mtd/mtd-abi.h>	/* Include struct erase_info_user */

#define DATE_RESTORE_SIZE	0x10000

extern void rtc_time_to_tm(unsigned long time, struct rtc_time *tm);
extern int rtc_tm_to_time(struct rtc_time *tm, unsigned long *time);

struct init_time {
	unsigned int init_sec;	/* The number in Real-Time clock */
	unsigned int date_sec;	/* The seconds of the date,
				 * which offsets 1900
				 */
};

int mcf_hwclk(int op, struct rtc_time *t)
{
	unsigned long cur_sec, date_sec, offset;
	struct init_time *date;
	int fd, i;
	unsigned char *storebuf;

	storebuf = (unsigned char *)kmalloc(DATE_RESTORE_SIZE, GFP_KERNEL);

	struct erase_info_user erase_sec =
			{.start = 0, 
			 .length = DATE_RESTORE_SIZE};
	if(!storebuf) {
		printk("Err: can't kmalloc buffer!\n");
		return -1;
	}

#if defined(CONFIG_MTD_UCLINUX)
	fd = sys_open("/dev/mtd2", O_RDWR, 0);
	i = 2;
#else
	fd = sys_open("/dev/mtd1", O_RDWR, 0);
	i = 1;
#endif
	if(fd < 0) {
		printk("Err: /dev/mtd%d doesn't exist!\n", i);
		kfree(storebuf);
		return -1;
	}

	cur_sec = MCF_RTC_TIME;
	sys_read(fd, storebuf, DATE_RESTORE_SIZE);

	date = (struct init_time *)storebuf;

	if(!op) {
    		/* read */
		if(MCF_RTC_MISC & MCF_RTC_MISC_RTCPL) {
			printk("WARN: Real-time clock power loss.\n");
			printk("      Date information may be corrupt!\n");
		}

		/* printk("init sec = 0x%08x, date sec = 0x%08x\n",
				date->init_sec, date->date_sec); */

		if(date->init_sec == 0xffffffff && date->date_sec == 0xffffffff) {
			printk("Real-time clock has not been initialized!\n");
			date->init_sec = 0;
			date->date_sec = 0;
		}

		offset = cur_sec - date->init_sec;
		rtc_time_to_tm(date->date_sec + offset, t);
	} else {
     		/* write */
		rtc_tm_to_time(t, &date_sec);

		date->init_sec = cur_sec;
		date->date_sec = date_sec;

		sys_ioctl(fd, MEMERASE, (unsigned long)&erase_sec);
		sys_lseek(fd, 0, 0);
		sys_write(fd, storebuf, DATE_RESTORE_SIZE);

                /* Toggle RTC power loss clear flag */
		MCF_RTC_MISC |=  MCF_RTC_MISC_RTCCLR;
		MCF_RTC_MISC &= ~MCF_RTC_MISC_RTCCLR;
  	}

	kfree(storebuf);

	sys_close(fd);
	return 0;
}
#else
int mcf_hwclk(int op, struct rtc_time *t)
{
	return 0;
}
#endif

/***************************************************************************/

void config_BSP(char *commandp, int size)
{
    	mcf_setimr(MCFSIM_IMR_MASKALL);

    	/* Copy command line from FLASH to local buffer... */
    	memcpy(commandp, (char *) 0xFFE04000, 4);
    	if(strncmp(commandp, "kcl ", 4) == 0){
        	memcpy(commandp, (char *) 0xFFE04004, size);
        	commandp[size-1] = 0;
   	}
    	else
#ifdef CONFIG_BOOTPARAM
    	{
        	strncpy(commandp, CONFIG_BOOTPARAM_STRING, size);
        	commandp[size-1] = 0;
    	}
#else
    	{
        	strncpy(commandp, "rootfstype=romfs", size);
        	commandp[size-1] = 0;
    	}
#endif

    	mach_sched_init      = coldfire_timer_init;
    	mach_tick    	     = coldfire_tick;
    	mach_gettimeoffset   = coldfire_timer_offset;
    	mach_trap_init 	     = coldfire_trap_init;
    	mach_gettod          = NULL;
    	mach_hwclk           = mcf_hwclk;
    	mach_set_clock_mmss  = NULL;
    	mach_reset 	     = coldfire_reset;
}

/***************************************************************************/
