/* Andrey Butok
 * Copyright Freescale Semiconductor Inc.  2006
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  either version 2 of the  License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MAX3353_MCF532X_H
#define MAX3353_MCF532X_H

#include <linux/usb_otg.h>
#include <asm/otg_fsm.h>

/* MAX3353 registers:*/

/* Manufacturer and ID Registers (read only) */
#define	MAX3353_MANUFACTURER_0					(0x00)
#	define	MAX3353_MANUFACTURER_0_VALUE			(0x6A)
#define	MAX3353_MANUFACTURER_1					(0x01)
#	define	MAX3353_MANUFACTURER_1_VALUE			(0x0B)
#define	MAX3353_MANUFACTURER_2					(0x02)
#	define	MAX3353_MANUFACTURER_2_VALUE			(0x53)
#define	MAX3353_MANUFACTURER_3					(0x03)
#	define	MAX3353_MANUFACTURER_3_VALUE			(0x33)
#define	MAX3353_PRODUCT_ID_0					(0x04)
#	define	MAX3353_PRODUCT_ID_0_VALUE			(0x48)
#define	MAX3353_PRODUCT_ID_1					(0x05)
#	define	MAX3353_PRODUCT_ID_1_VALUE			(0x5A)
#define	MAX3353_PRODUCT_ID_2					(0x06)
#	define	MAX3353_PRODUCT_ID_2_VALUE			(0x42)
#define	MAX3353_PRODUCT_ID_3					(0x07)

/* Control Registers */
#define	MAX3353_CONTROL_1					(0x10)
#	define	MAX3353_CONTROL_1_IRQ_MODE			(1<<1)
#	define	MAX3353_CONTROL_1_BDISC_ACONN			(1<<2)
#	define	MAX3353_CONTROL_1_DP_PULLUP			(1<<4)
#	define	MAX3353_CONTROL_1_DM_PULLUP			(1<<5)
#	define	MAX3353_CONTROL_1_DP_PULLDWN			(1<<6)
#	define	MAX3353_CONTROL_1_DM_PULLDWN			(1<<7)
#define	MAX3353_CONTROL_2					(0x11)
#	define	MAX3353_CONTROL_2_SDWN				(1<<0)
#	define	MAX3353_CONTROL_2_VBUS_CHG1			(1<<1)
#	define	MAX3353_CONTROL_2_VBUS_CHG2			(1<<2)
#	define	MAX3353_CONTROL_2_VBUS_DRV			(1<<3)
#	define	MAX3353_CONTROL_2_VBUS_DISCHG			(1<<4)

/* Status Register */
#define	MAX3353_STATUS						(0x13)
#	define	MAX3353_STATUS_VBUS_VALID			(1<<0)
#	define	MAX3353_STATUS_SESSION_VALID			(1<<1)
#	define	MAX3353_STATUS_SESSION_END			(1<<2)
#	define	MAX3353_STATUS_SESSION_ID_GND			(1<<3)
#	define	MAX3353_STATUS_SESSION_ID_FLOAT			(1<<4)
#	define	MAX3353_STATUS_SESSION_A_HNP			(1<<5)
#	define	MAX3353_STATUS_SESSION_B_HNP			(1<<6)

/* Interrupt Registers */
#define	MAX3353_INTERRUPT_MASK					(0x14)
#	define	MAX3353_INTERRUPT_MASK_VBUS_VALID_EN		(1<<0)
#	define	MAX3353_INTERRUPT_MASK_SESSION_VALID_EN		(1<<1)
#	define	MAX3353_INTERRUPT_MASK_SESSION_END_EN		(1<<2)
#	define	MAX3353_INTERRUPT_MASK_ID_GND_EN		(1<<3)
#	define	MAX3353_INTERRUPT_MASK_ID_FLOAT_EN		(1<<4)
#	define	MAX3353_INTERRUPT_MASK_A_HNP_EN			(1<<5)
#define	MAX3353_INTERRUPT_EDGE					(0x15)
#	define	MAX3353_INTERRUPT_EDGE_VBUS_VALID_ED		(1<<0)
#	define	MAX3353_INTERRUPT_EDGE_SESSION_VALID_ED		(1<<1)
#define	MAX3353_INTERRUPT_LATCH					(0x16)
#	define	MAX3353_INTERRUPT_LATCH_VBUS_VALID_RP		(1<<0)
#	define	MAX3353_INTERRUPT_LATCH_SESSION_VALID_RP	(1<<1)
#	define	MAX3353_INTERRUPT_LATCH_VBUS_VALID_RN		(1<<2)
#	define	MAX3353_INTERRUPT_LATCH_SESSION_VALID_RN	(1<<3)
#	define	MAX3353_INTERRUPT_LATCH_SESSION_END_RQ		(1<<4)
#	define	MAX3353_INTERRUPT_LATCH_ID_GND_RQ		(1<<5)
#	define	MAX3353_INTERRUPT_LATCH_ID_FLOAT_RQ		(1<<6)
#	define	MAX3353_INTERRUPT_LATCH_A_HNP_RQ		(1<<7)

#define ERR(format, arg...) \
printk(KERN_ERR "%s:%s: " format "\n" , __FILE__,  __FUNCTION__ , ## arg)

/*
 *  A-DEVICE timing  constants
 */

/* Wait for VBUS Rise  */
#define TA_WAIT_VRISE	(100)	/* a_wait_vrise 100 ms, section: 6.6.5.1 */

/* Wait for B-Connect */
#define TA_WAIT_BCON	(10000)	/* a_wait_bcon > 1 sec, section: 6.6.5.2
				 * This is only used to get out of
				 * OTG_STATE_A_WAIT_BCON state if there was
				 * no connection for these many milliseconds
				 */

/* A-Idle to B-Disconnect */
/* It is necessary for this timer to be more than 750 ms because of a bug in OPT
 * test 5.4 in which B OPT disconnects after 750 ms instead of 75ms as stated
 * in the test description
 */
#define TA_AIDL_BDIS	(5000)	/* a_suspend minimum 200 ms, section: 6.6.5.3 */

/* B-Idle to A-Disconnect */
#define TA_BIDL_ADIS	(12)	/* 3 to 200 ms */

/* B-device timing constants */

/* Data-Line Pulse Time*/
#define TB_DATA_PLS	(10)	/* b_srp_init,continue 5~10ms, section:5.3.3 */
#define TB_DATA_PLS_MIN	(5)	/* minimum 5 ms */
#define TB_DATA_PLS_MAX	(10)	/* maximum 10 ms */

/* SRP Initiate Time  */
#define TB_SRP_INIT	(100)	/* b_srp_init,maximum 100 ms, section:5.3.8 */

/* SRP Fail Time  */
#define TB_SRP_FAIL	(7000)	/* b_srp_init,Fail time 5~30s, section:6.8.2.2 */

/* SRP result wait time */
#define TB_SRP_WAIT	(60)

/* VBus time */
#define TB_VBUS_PLS	(30)	/* time to keep vbus pulsing asserted */

/* Discharge time */
/* This time should be less than 10ms. It varies from system to system. */
#define TB_VBUS_DSCHRG	(8)

/* A-SE0 to B-Reset  */
#define TB_ASE0_BRST	(2000)	/*(20)*/    /* b_wait_acon, mini 3.125 ms,section:6.8.2.4 */

/* A bus suspend timer before we can switch to b_wait_aconn */
#define TB_A_SUSPEND	(7)
#define TB_BUS_RESUME	(12)

/* SE0 Time Before SRP */
#define TB_SE0_SRP	(2)	/* b_idle,minimum 2 ms, section:5.3.2 */

#define SET_OTG_STATE(otg_ptr, newstate)	((otg_ptr)->state=newstate)

struct max3353_otg_timer {
	unsigned long expires;	/* Number of count increase to timeout */
	unsigned long count;	/* Tick counter */
	void (*function) (unsigned long);	/* Timeout function */
	unsigned long data;	/* Data passed to function */
	struct list_head list;
};

struct max3353_otg_timer inline *max3353_otg_timer_initializer
    (void (*function) (unsigned long), unsigned long expires,
     unsigned long data) {
	struct max3353_otg_timer *timer;
	timer = kmalloc(sizeof (struct max3353_otg_timer), GFP_KERNEL);
	timer->function = function;
	timer->expires = expires;
	timer->data = data;
	return timer;
}

struct max3353 {
	struct otg_transceiver otg;
	struct i2c_client client;
	struct otg_fsm fsm;
	void (*i2c_release) (struct device * dev);
	int irq;
	int irq_otg;
	unsigned host_working:1;
	int delay_id_cnt;
	int delay_id;
	int delay_b_conn_cnt;
	int delay_b_conn;
	int delay_a_conn_cnt;
	int delay_a_conn;
	int delay_b_bus_suspend_cnt;
	int delay_b_bus_suspend;
};

/* Register read/write macros */
#define MCF_USB0_ID			(*(volatile u32   *)(0xFC0B0000))
#define MCF_USB0_CAPLENGTH		(*(volatile u8    *)(0xFC0B0100))
#define MCF_USB0_HCIVERSION		(*(volatile u16   *)(0xFC0B0102))
#define MCF_USB0_HCSPARAMS		(*(volatile u32   *)(0xFC0B0104))
#define MCF_USB0_HCCPARAMS		(*(volatile u32   *)(0xFC0B0108))
#define MCF_USB0_DCIVERSION		(*(volatile u16   *)(0xFC0B0120))
#define MCF_USB0_DCCPARAMS		(*(volatile u32   *)(0xFC0B0124))
#define MCF_USB0_USBCMD			(*(volatile u32   *)(0xFC0B0140))
#define MCF_USB0_USBSTS			(*(volatile u32   *)(0xFC0B0144))
#define MCF_USB0_USBINTR		(*(volatile u32   *)(0xFC0B0148))
#define MCF_USB0_FRINDEX		(*(volatile u32   *)(0xFC0B014C))
#define MCF_USB0_PERIODICLISTBASE	(*(volatile u32   *)(0xFC0B0154))
#define MCF_USB0_DEVICEADDR		(*(volatile u32   *)(0xFC0B0154))
#define MCF_USB0_ASYNCLISTADDR		(*(volatile u32   *)(0xFC0B0158))
#define MCF_USB0_EPLISTADDR		(*(volatile u32   *)(0xFC0B0158))
#define MCF_USB0_ASNCTTSTS		(*(volatile u32   *)(0xFC0B015C))
#define MCF_USB0_BURSTSIZE		(*(volatile u32   *)(0xFC0B0160))
#define MCF_USB0_TXFILLTUNING		(*(volatile u32   *)(0xFC0B0164))
#define MCF_USB0_TXTTFILLTUNING		(*(volatile u32   *)(0xFC0B0168))
#define MCF_USB0_ULPI_VIEWPORT		(*(volatile u32   *)(0xFC0B0170))
#define MCF_USB0_CONFIGFLAG		(*(volatile u32   *)(0xFC0B0180))
#define MCF_USB0_PORTSC			(*(volatile u32   *)(0xFC0B0184))
#define MCF_USB0_OTGSC			(*(volatile u32   *)(0xFC0B01A4))
#define MCF_USB0_USBMODE		(*(volatile u32   *)(0xFC0B01A8))
#define MCF_USB0_EPSETUPSR		(*(volatile u32   *)(0xFC0B01AC))
#define MCF_USB0_EPPRIME		(*(volatile u32   *)(0xFC0B01B0))
#define MCF_USB0_EPFLUSH		(*(volatile u32   *)(0xFC0B01B4))
#define MCF_USB0_EPSR			(*(volatile u32   *)(0xFC0B01B8))
#define MCF_USB0_EPCOMPLETE		(*(volatile u32   *)(0xFC0B01BC))
#define MCF_USB0_EPCR0			(*(volatile u32   *)(0xFC0B01C0))
#define MCF_USB0_EPCR1			(*(volatile u32   *)(0xFC0B01C4))
#define MCF_USB0_EPCR2			(*(volatile u32   *)(0xFC0B01C8))
#define MCF_USB0_EPCR3			(*(volatile u32   *)(0xFC0B01CC))
#define MCF_USB0_EPCR(x)		(*(volatile u32   *)(0xFC0B01C0+((x)*0x004)))

/* Bit definitions and macros for MCF_USB_USBCMD */
#define MCF_USB_USBCMD_RS			(0x00000001)
#define MCF_USB_USBCMD_RST			(0x00000002)
#define MCF_USB_USBCMD_FS0			(0x00000004)
#define MCF_USB_USBCMD_FS1			(0x00000008)
#define MCF_USB_USBCMD_PSE			(0x00000010)
#define MCF_USB_USBCMD_ASE			(0x00000020)
#define MCF_USB_USBCMD_IAA			(0x00000040)
#define MCF_USB_USBCMD_LR			(0x00000080)
#define MCF_USB_USBCMD_ASP(x)			(((x)&0x00000003)<<8)
#define MCF_USB_USBCMD_ASPE			(0x00000800)
#define MCF_USB_USBCMD_SUTW			(0x00002000)
#define MCF_USB_USBCMD_ATDTW			(0x00004000)
#define MCF_USB_USBCMD_FS2			(0x00008000)
#define MCF_USB_USBCMD_ITC(x)			(((x)&0x000000FF)<<16)
#define MCF_USB_USBCMD_ITC_IMM			(0x00000000)
#define MCF_USB_USBCMD_ITC_1			(0x00010000)
#define MCF_USB_USBCMD_ITC_2			(0x00020000)
#define MCF_USB_USBCMD_ITC_4			(0x00040000)
#define MCF_USB_USBCMD_ITC_8			(0x00080000)
#define MCF_USB_USBCMD_ITC_16			(0x00100000)
#define MCF_USB_USBCMD_ITC_32			(0x00200000)
#define MCF_USB_USBCMD_ITC_40			(0x00400000)
#define MCF_USB_USBCMD_FS_1024			(0x00000000)
#define MCF_USB_USBCMD_FS_512			(0x00000004)
#define MCF_USB_USBCMD_FS_256			(0x00000008)
#define MCF_USB_USBCMD_FS_128			(0x0000000C)
#define MCF_USB_USBCMD_FS_64			(0x00008000)
#define MCF_USB_USBCMD_FS_32			(0x00008004)
#define MCF_USB_USBCMD_FS_16			(0x00008008)
#define MCF_USB_USBCMD_FS_8			(0x0000800C)

/* Bit definitions and macros for MCF_USB_PORTSC */
#define MCF_USB_PORTSC_CCS			(0x00000001)
#define MCF_USB_PORTSC_CSC			(0x00000002)
#define MCF_USB_PORTSC_PE			(0x00000004)
#define MCF_USB_PORTSC_PEC			(0x00000008)
#define MCF_USB_PORTSC_OCA			(0x00000010)
#define MCF_USB_PORTSC_OCC			(0x00000020)
#define MCF_USB_PORTSC_FPR			(0x00000040)
#define MCF_USB_PORTSC_SUSP			(0x00000080)
#define MCF_USB_PORTSC_PR			(0x00000100)
#define MCF_USB_PORTSC_LS(x)			(((x)&0x00000003)<<10)
#define MCF_USB_PORTSC_PP			(0x00001000)
#define MCF_USB_PORTSC_PO			(0x00002000)
#define MCF_USB_PORTSC_PIC(x)			(((x)&0x00000003)<<14)
#define MCF_USB_PORTSC_PTC(x)			(((x)&0x0000000F)<<16)
#define MCF_USB_PORTSC_WLCN			(0x00100000)
#define MCF_USB_PORTSC_WKDS			(0x00200000)
#define MCF_USB_PORTSC_WKOC			(0x00400000)
#define MCF_USB_PORTSC_PHCD			(0x00800000)
#define MCF_USB_PORTSC_PFSC			(0x01000000)
#define MCF_USB_PORTSC_PTS(x)			(((x)&0x00000003)<<30)
#define MCF_USB_PORTSC_PTS_ULPI			(0x80000000)
#define MCF_USB_PORTSC_PTS_FS_LS		(0xC0000000)
#define MCF_USB_PORTSC_PSPD			(0x0C000000)
#define MCF_USB_PORTSC_PSPD_FULL		(0x00000000)
#define MCF_USB_PORTSC_PSPD_LOW			(0x04000000)
#define MCF_USB_PORTSC_PSPD_HIGH		(0x08000000)
#define MCF_USB_PORTSC_PTC_DISBALE		(0x00000000)
#define MCF_USB_PORTSC_PTC_JSTATE		(0x00010000)
#define MCF_USB_PORTSC_PTC_KSTATE		(0x00020000)
#define MCF_USB_PORTSC_PTC_SEQ_NAK		(0x00030000)
#define MCF_USB_PORTSC_PTC_PACKET		(0x00040000)
#define MCF_USB_PORTSC_PTC_FORCE_ENABLE		(0x00050000)
#define MCF_USB_PORTSC_PIC_OFF			(0x00000000)
#define MCF_USB_PORTSC_PIC_AMBER		(0x00004000)
#define MCF_USB_PORTSC_PIC_GREEN		(0x00008000)
#define MCF_USB_PORTSC_LS_SE0			(0x00000000)
#define MCF_USB_PORTSC_LS_JSTATE		(0x00000400)
#define MCF_USB_PORTSC_LS_KSTATE		(0x00000800)

/* USB Status Register Bit Masks */
#define USB_STS_PORT_CHANGE		(0x1<<2 )
#define USB_STS_DCSUSPEND		(0x1<<8 )

/* PORTSC  Register Bit Masks,Only one PORT in OTG mode*/
#define PORTSC_CURRENT_CONNECT_STATUS	(0x1<<0 )
#define PORTSC_CONNECT_STATUS_CHANGE	(0x1<<1 )
#define PORTSC_PORT_ENABLE		(0x1<<2 )
#define PORTSC_PORT_EN_DIS_CHANGE	(0x1<<3 )
#define PORTSC_OVER_CURRENT_ACT		(0x1<<4 )
#define PORTSC_OVER_CUURENT_CHG		(0x1<<5 )
#define PORTSC_PORT_FORCE_RESUME	(0x1<<6 )
#define PORTSC_PORT_SUSPEND		(0x1<<7 )
#define PORTSC_PORT_RESET		(0x1<<8 )
#define PORTSC_LINE_STATUS_BITS		(0x3<<10)
#define PORTSC_PORT_POWER		(0x1<<12)
#define PORTSC_PORT_INDICTOR_CTRL	(0x3<<14)
#define PORTSC_PORT_TEST_CTRL		(0xF<<16)
#define PORTSC_WAKE_ON_CONNECT_EN	(0x1<<20)
#define PORTSC_WAKE_ON_CONNECT_DIS	(0x1<<21)
#define PORTSC_WAKE_ON_OVER_CURRENT	(0x1<<22)
#define PORTSC_PHY_LOW_POWER_SPD	(0x1<<23)
#define PORTSC_PORT_FORCE_FULL_SPEED	(0x1<<24)
#define PORTSC_PORT_SPEED_MASK		(0x3<<26)
#define PORTSC_TRANSCEIVER_WIDTH	(0x1<<28)
#define PORTSC_PHY_TYPE_SEL		(0x3<<30)

#define PORTSC_W1C_BITS                     \
       ( PORTSC_CONNECT_STATUS_CHANGE |     \
         PORTSC_PORT_EN_DIS_CHANGE    |     \
         PORTSC_OVER_CUURENT_CHG )

/* OTG Status Control Register Bit Masks */
#define OTGSC_CTRL_VBUS_DISCHARGE	(0x1<<0 )
#define OTGSC_CTRL_VBUS_CHARGE		(0x1<<1 )
#define OTGSC_CTRL_OTG_TERMINATION	(0x1<<3 )
#define OTGSC_CTRL_DATA_PULSING		(0x1<<4 )
#define OTGSC_CTRL_ID_PULL_EN		(0x1<<5 )
#define OTGSC_HA_DATA_PULSE		(0x1<<6 )
#define OTGSC_HA_BA			(0x1<<7 )
#define OTGSC_STS_USB_ID		(0x1<<8 )
#define OTGSC_STS_A_VBUS_VALID		(0x1<<9 )
#define OTGSC_STS_A_SESSION_VALID	(0x1<<10)
#define OTGSC_STS_B_SESSION_VALID	(0x1<<11)
#define OTGSC_STS_B_SESSION_END		(0x1<<12)
#define OTGSC_STS_1MS_TOGGLE		(0x1<<13)
#define OTGSC_STS_DATA_PULSING		(0x1<<14)
#define OTGSC_INTSTS_USB_ID		(0x1<<16)
#define OTGSC_INTSTS_A_VBUS_VALID	(0x1<<17)
#define OTGSC_INTSTS_A_SESSION_VALID	(0x1<<18)
#define OTGSC_INTSTS_B_SESSION_VALID	(0x1<<19)
#define OTGSC_INTSTS_B_SESSION_END	(0x1<<20)
#define OTGSC_INTSTS_1MS		(0x1<<21)
#define OTGSC_INTSTS_DATA_PULSING	(0x1<<22)
#define OTGSC_INTR_USB_ID_EN		(0x1<<24)
#define OTGSC_INTR_A_VBUS_VALID_EN	(0x1<<25)
#define OTGSC_INTR_A_SESSION_VALID_EN	(0x1<<26)
#define OTGSC_INTR_B_SESSION_VALID_EN	(0x1<<27)
#define OTGSC_INTR_B_SESSION_END_EN	(0x1<<28)
#define OTGSC_INTR_1MS_TIMER_EN		(0x1<<29)
#define OTGSC_INTR_DATA_PULSING_EN	(0x1<<30)
#define OTGSC_INTSTS_MASK		(0x00ff0000)

#endif
