/****************************************************************************/

/*
 *	m527xsim.h -- ColdFire 5270/5271 System Integration Module support.
 *
 *	(C) Copyright 2004, Greg Ungerer (gerg@snapgear.com)
 *
 *	Ultan Henry, 2008 - Add many register definitions
 */

/****************************************************************************/
#ifndef	m527xsim_h
#define	m527xsim_h
/****************************************************************************/

#include <linux/config.h>

#define MCF_REG32(x) (*(volatile unsigned long  *)(x))
#define MCF_REG16(x) (*(volatile unsigned short *)(x))
#define MCF_REG08(x) (*(volatile unsigned char  *)(x))

/*
 *	Define the 5270/5271 SIM register set addresses.
 */
#define	MCFICM_INTC0		0x0c00		/* Base for Interrupt Ctrl 0 */
#define	MCFICM_INTC1		0x0d00		/* Base for Interrupt Ctrl 1 */
#define	MCFINTC_IPRH		0x00		/* Interrupt pending 32-63 */
#define	MCFINTC_IPRL		0x04		/* Interrupt pending 1-31 */
#define	MCFINTC_IMRH		0x08		/* Interrupt mask 32-63 */
#define	MCFINTC_IMRL		0x0c		/* Interrupt mask 1-31 */
#define	MCFINTC_INTFRCH		0x10		/* Interrupt force 32-63 */
#define	MCFINTC_INTFRCL		0x14		/* Interrupt force 1-31 */
#define	MCFINTC_IRLR		0x18		/* */
#define	MCFINTC_IACKL		0x19		/* */
#define	MCFINTC_ICR0		0x40		/* Base ICR register */

#define	MCFINT_VECBASE		64		/* Vector base number */
#define	MCFINT_UART0		13		/* Interrupt number for UART0 */
#define	MCFINT_UART1		14		/* Interrupt number for UART1 */
#define	MCFINT_UART2		15		/* Interrupt number for UART2 */
#define	MCFINT_PIT1		36		/* Interrupt number for PIT1 */
#define MCFINT_QSPI		18		/* Interrupt number for QSPI */

/*
 *	SDRAM configuration registers.
 */
#ifdef CONFIG_M5271
#define	MCFSIM_DCR		0x40		/* SDRAM control */
#define	MCFSIM_DACR0		0x48		/* SDRAM base address 0 */
#define	MCFSIM_DMR0		0x4c		/* SDRAM address mask 0 */
#define	MCFSIM_DACR1		0x50		/* SDRAM base address 1 */
#define	MCFSIM_DMR1		0x54		/* SDRAM address mask 1 */
#endif
#ifdef CONFIG_M5275
#define	MCFSIM_DMR		0x40		/* SDRAM mode */
#define	MCFSIM_DCR		0x44		/* SDRAM control */
#define	MCFSIM_DCFG1		0x48		/* SDRAM configuration 1 */
#define	MCFSIM_DCFG2		0x4c		/* SDRAM configuration 2 */
#define	MCFSIM_DBAR0		0x50		/* SDRAM base address 0 */
#define	MCFSIM_DMR0		0x54		/* SDRAM address mask 0 */
#define	MCFSIM_DBAR1		0x58		/* SDRAM base address 1 */
#define	MCFSIM_DMR1		0x5c		/* SDRAM address mask 1 */
#endif

/*
 *	GPIO pins setups to enable the UARTs.
 */
#ifdef CONFIG_M5271
#define MCF_GPIO_PAR_UART	0x100048	/* PAR UART address */
#define UART0_ENABLE_MASK	0x000f
#define UART1_ENABLE_MASK	0x0ff0
#define UART2_ENABLE_MASK	0x3000
#endif
#ifdef CONFIG_M5275
#define MCF_GPIO_PAR_UART	0x10007c	/* PAR UART address */
#define UART0_ENABLE_MASK	0x000f
#define UART1_ENABLE_MASK	0x00f0
#define UART2_ENABLE_MASK	0x3f00 
#endif

/****************************************************************************/
/*   Ultan Henry, 2008 - Add many register definitions			    */
/****************************************************************************/

/*********************************************************************
*
* General Purpose I/O (GPIO)
*
*********************************************************************/

/* Register read/write macros */
#define MCF_GPIO_PODR_ADDR        MCF_REG08(MCF_IPSBAR + 0x100000)
#define MCF_GPIO_PODR_DATAH       MCF_REG08(MCF_IPSBAR + 0x100001)
#define MCF_GPIO_PODR_DATAL       MCF_REG08(MCF_IPSBAR + 0x100002)
#define MCF_GPIO_PODR_BUSCTL      MCF_REG08(MCF_IPSBAR + 0x100003)
#define MCF_GPIO_PODR_BS          MCF_REG08(MCF_IPSBAR + 0x100004)
#define MCF_GPIO_PODR_CS          MCF_REG08(MCF_IPSBAR + 0x100005)
#define MCF_GPIO_PODR_SDRAM       MCF_REG08(MCF_IPSBAR + 0x100006)
#define MCF_GPIO_PODR_FECI2C      MCF_REG08(MCF_IPSBAR + 0x100007)
#define MCF_GPIO_PODR_UARTH       MCF_REG08(MCF_IPSBAR + 0x100008)
#define MCF_GPIO_PODR_UARTL       MCF_REG08(MCF_IPSBAR + 0x100009)
#define MCF_GPIO_PODR_QSPI        MCF_REG08(MCF_IPSBAR + 0x10000A)
#define MCF_GPIO_PODR_TIMER       MCF_REG08(MCF_IPSBAR + 0x10000B)
#define MCF_GPIO_PDDR_APDDR       MCF_REG08(MCF_IPSBAR + 0x100010)
#define MCF_GPIO_PDDR_DATAH       MCF_REG08(MCF_IPSBAR + 0x100011)
#define MCF_GPIO_PDDR_DATAL       MCF_REG08(MCF_IPSBAR + 0x100012)
#define MCF_GPIO_PDDR_BUSCTL      MCF_REG08(MCF_IPSBAR + 0x100013)
#define MCF_GPIO_PDDR_BS          MCF_REG08(MCF_IPSBAR + 0x100014)
#define MCF_GPIO_PDDR_CS          MCF_REG08(MCF_IPSBAR + 0x100015)
#define MCF_GPIO_PDDR_SDRAM       MCF_REG08(MCF_IPSBAR + 0x100016)
#define MCF_GPIO_PDDR_FECI2C      MCF_REG08(MCF_IPSBAR + 0x100017)
#define MCF_GPIO_PDDR_UARTH       MCF_REG08(MCF_IPSBAR + 0x100018)
#define MCF_GPIO_PDDR_UARTL       MCF_REG08(MCF_IPSBAR + 0x100019)
#define MCF_GPIO_PDDR_QSPI        MCF_REG08(MCF_IPSBAR + 0x10001A)
#define MCF_GPIO_PDDR_TIMER       MCF_REG08(MCF_IPSBAR + 0x10001B)
#define MCF_GPIO_PPDSDR_ADDR      MCF_REG08(MCF_IPSBAR + 0x100020)
#define MCF_GPIO_PPDSDR_DATAH     MCF_REG08(MCF_IPSBAR + 0x100021)
#define MCF_GPIO_PPDSDR_DATAL     MCF_REG08(MCF_IPSBAR + 0x100022)
#define MCF_GPIO_PPDSDR_BUSCTL    MCF_REG08(MCF_IPSBAR + 0x100023)
#define MCF_GPIO_PPDSDR_BS        MCF_REG08(MCF_IPSBAR + 0x100024)
#define MCF_GPIO_PPDSDR_FECI2C    MCF_REG08(MCF_IPSBAR + 0x100027)
#define MCF_GPIO_PPDSDR_CS        MCF_REG08(MCF_IPSBAR + 0x100025)
#define MCF_GPIO_PPDSDR_SDRAM     MCF_REG08(MCF_IPSBAR + 0x100026)
#define MCF_GPIO_PPDSDR_UARTH     MCF_REG08(MCF_IPSBAR + 0x100028)
#define MCF_GPIO_PPDSDR_UARTL     MCF_REG08(MCF_IPSBAR + 0x100029)
#define MCF_GPIO_PPDSDR_QSPI      MCF_REG08(MCF_IPSBAR + 0x10002A)
#define MCF_GPIO_PPDSDR_TIMER     MCF_REG08(MCF_IPSBAR + 0x10002B)
#define MCF_GPIO_PCLRR_ADDR       MCF_REG08(MCF_IPSBAR + 0x100030)
#define MCF_GPIO_PCLRR_DATAH      MCF_REG08(MCF_IPSBAR + 0x100031)
#define MCF_GPIO_PCLRR_DATAL      MCF_REG08(MCF_IPSBAR + 0x100032)
#define MCF_GPIO_PCLRR_BUSCTL     MCF_REG08(MCF_IPSBAR + 0x100033)
#define MCF_GPIO_PCLRR_BS         MCF_REG08(MCF_IPSBAR + 0x100034)
#define MCF_GPIO_PCLRR_CS         MCF_REG08(MCF_IPSBAR + 0x100035)
#define MCF_GPIO_PCLRR_SDRAM      MCF_REG08(MCF_IPSBAR + 0x100036)
#define MCF_GPIO_PCLRR_FECI2C     MCF_REG08(MCF_IPSBAR + 0x100037)
#define MCF_GPIO_PCLRR_UARTH      MCF_REG08(MCF_IPSBAR + 0x100038)
#define MCF_GPIO_PCLRR_UARTL      MCF_REG08(MCF_IPSBAR + 0x100039)
#define MCF_GPIO_PCLRR_QSPI       MCF_REG08(MCF_IPSBAR + 0x10003A)
#define MCF_GPIO_PCLRR_TIMER      MCF_REG08(MCF_IPSBAR + 0x10003B)
#define MCF_GPIO_PAR_AD           MCF_REG08(MCF_IPSBAR + 0x100040)
#define MCF_GPIO_PAR_BUSCTL       MCF_REG16(MCF_IPSBAR + 0x100042)
#define MCF_GPIO_PAR_BS           MCF_REG08(MCF_IPSBAR + 0x100044)
#define MCF_GPIO_PAR_CS           MCF_REG08(MCF_IPSBAR + 0x100045)
#define MCF_GPIO_PAR_SDRAM        MCF_REG08(MCF_IPSBAR + 0x100046)
#define MCF_GPIO_PAR_FECI2C       MCF_REG08(MCF_IPSBAR + 0x100047)
#define MCF_GPIO_PAR_UART_REG     MCF_REG16(MCF_IPSBAR + 0x100048)
#define MCF_GPIO_PAR_QSPI         MCF_REG08(MCF_IPSBAR + 0x10004A)
#define MCF_GPIO_PAR_TIMER        MCF_REG16(MCF_IPSBAR + 0x10004C)
#define MCF_GPIO_DSCR_EIM         MCF_REG08(MCF_IPSBAR + 0x100050)
#define MCF_GPIO_DSCR_FECI2C      MCF_REG08(MCF_IPSBAR + 0x100052)
#define MCF_GPIO_DSCR_UART        MCF_REG08(MCF_IPSBAR + 0x100053)
#define MCF_GPIO_DSCR_QSPI        MCF_REG08(MCF_IPSBAR + 0x100054)
#define MCF_GPIO_DSCR_TIMER       MCF_REG08(MCF_IPSBAR + 0x100055)

/* Bit definitions and macros for MCF_GPIO_PODR_ADDR */
#define MCF_GPIO_PODR_ADDR_PODR_ADDR5            (0x20)
#define MCF_GPIO_PODR_ADDR_PODR_ADDR6            (0x40)
#define MCF_GPIO_PODR_ADDR_PODR_ADDR7            (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_DATAH */
#define MCF_GPIO_PODR_DATAH_PODR_DATAH0          (0x01)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH1          (0x02)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH2          (0x04)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH3          (0x08)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH4          (0x10)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH5          (0x20)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH6          (0x40)
#define MCF_GPIO_PODR_DATAH_PODR_DATAH7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_DATAL */
#define MCF_GPIO_PODR_DATAL_PODR_DATAL0          (0x01)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL1          (0x02)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL2          (0x04)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL3          (0x08)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL4          (0x10)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL5          (0x20)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL6          (0x40)
#define MCF_GPIO_PODR_DATAL_PODR_DATAL7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_BUSCTL */
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL0        (0x01)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL1        (0x02)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL2        (0x04)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL3        (0x08)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL4        (0x10)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL5        (0x20)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL6        (0x40)
#define MCF_GPIO_PODR_BUSCTL_PODR_BUSCTL7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_BS */
#define MCF_GPIO_PODR_BS_PODR_BS0                (0x01)
#define MCF_GPIO_PODR_BS_PODR_BS1                (0x02)
#define MCF_GPIO_PODR_BS_PODR_BS2                (0x04)
#define MCF_GPIO_PODR_BS_PODR_BS3                (0x08)

/* Bit definitions and macros for MCF_GPIO_PODR_CS */
#define MCF_GPIO_PODR_CS_PODR_CS1                (0x02)
#define MCF_GPIO_PODR_CS_PODR_CS2                (0x04)
#define MCF_GPIO_PODR_CS_PODR_CS3                (0x08)
#define MCF_GPIO_PODR_CS_PODR_CS4                (0x10)
#define MCF_GPIO_PODR_CS_PODR_CS5                (0x20)
#define MCF_GPIO_PODR_CS_PODR_CS6                (0x40)
#define MCF_GPIO_PODR_CS_PODR_CS7                (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_SDRAM */
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM0          (0x01)
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM1          (0x02)
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM2          (0x04)
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM3          (0x08)
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM4          (0x10)
#define MCF_GPIO_PODR_SDRAM_PODR_SDRAM5          (0x20)

/* Bit definitions and macros for MCF_GPIO_PODR_FECI2C */
#define MCF_GPIO_PODR_FECI2C_PODR_FECI2C0        (0x01)
#define MCF_GPIO_PODR_FECI2C_PODR_FECI2C1        (0x02)
#define MCF_GPIO_PODR_FECI2C_PODR_FECI2C2        (0x04)
#define MCF_GPIO_PODR_FECI2C_PODR_FECI2C3        (0x08)

/* Bit definitions and macros for MCF_GPIO_PODR_UARTH */
#define MCF_GPIO_PODR_UARTH_PODR_UARTH0          (0x01)
#define MCF_GPIO_PODR_UARTH_PODR_UARTH1          (0x02)

/* Bit definitions and macros for MCF_GPIO_PODR_UARTL */
#define MCF_GPIO_PODR_UARTL_PODR_UARTL0          (0x01)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL1          (0x02)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL2          (0x04)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL3          (0x08)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL4          (0x10)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL5          (0x20)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL6          (0x40)
#define MCF_GPIO_PODR_UARTL_PODR_UARTL7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PODR_QSPI */
#define MCF_GPIO_PODR_QSPI_PODR_QSPI0            (0x01)
#define MCF_GPIO_PODR_QSPI_PODR_QSPI1            (0x02)
#define MCF_GPIO_PODR_QSPI_PODR_QSPI2            (0x04)
#define MCF_GPIO_PODR_QSPI_PODR_QSPI3            (0x08)
#define MCF_GPIO_PODR_QSPI_PODR_QSPI4            (0x10)

/* Bit definitions and macros for MCF_GPIO_PODR_TIMER */
#define MCF_GPIO_PODR_TIMER_PODR_TIMER0          (0x01)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER1          (0x02)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER2          (0x04)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER3          (0x08)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER4          (0x10)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER5          (0x20)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER6          (0x40)
#define MCF_GPIO_PODR_TIMER_PODR_TIMER7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_APDDR */
#define MCF_GPIO_PDDR_APDDR_PDDR_APDDR5          (0x20)
#define MCF_GPIO_PDDR_APDDR_PDDR_APDDR6          (0x40)
#define MCF_GPIO_PDDR_APDDR_PDDR_APDDR7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_DATAH */
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH0          (0x01)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH1          (0x02)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH2          (0x04)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH3          (0x08)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH4          (0x10)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH5          (0x20)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH6          (0x40)
#define MCF_GPIO_PDDR_DATAH_PDDR_DATAH7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_DATAL */
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL0          (0x01)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL1          (0x02)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL2          (0x04)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL3          (0x08)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL4          (0x10)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL5          (0x20)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL6          (0x40)
#define MCF_GPIO_PDDR_DATAL_PDDR_DATAL7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_BUSCTL */
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL0        (0x01)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL1        (0x02)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL2        (0x04)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL3        (0x08)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL4        (0x10)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL5        (0x20)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL6        (0x40)
#define MCF_GPIO_PDDR_BUSCTL_PDDR_BUSCTL7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_BS */
#define MCF_GPIO_PDDR_BS_PDDR_BS0                (0x01)
#define MCF_GPIO_PDDR_BS_PDDR_BS3(x)             (((x)&0x07)<<1)

/* Bit definitions and macros for MCF_GPIO_PDDR_CS */
#define MCF_GPIO_PDDR_CS_PDDR_CS1                (0x02)
#define MCF_GPIO_PDDR_CS_PDDR_CS2                (0x04)
#define MCF_GPIO_PDDR_CS_PDDR_CS3                (0x08)
#define MCF_GPIO_PDDR_CS_PDDR_CS4                (0x10)
#define MCF_GPIO_PDDR_CS_PDDR_CS5                (0x20)
#define MCF_GPIO_PDDR_CS_PDDR_CS6                (0x40)
#define MCF_GPIO_PDDR_CS_PDDR_CS7                (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_SDRAM */
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM0          (0x01)
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM1          (0x02)
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM2          (0x04)
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM3          (0x08)
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM4          (0x10)
#define MCF_GPIO_PDDR_SDRAM_PDDR_SDRAM5          (0x20)

/* Bit definitions and macros for MCF_GPIO_PDDR_FECI2C */
#define MCF_GPIO_PDDR_FECI2C_PDDR_FECI2C0        (0x01)
#define MCF_GPIO_PDDR_FECI2C_PDDR_FECI2C1        (0x02)
#define MCF_GPIO_PDDR_FECI2C_PDDR_FECI2C2        (0x04)
#define MCF_GPIO_PDDR_FECI2C_PDDR_FECI2C3        (0x08)

/* Bit definitions and macros for MCF_GPIO_PDDR_UARTH */
#define MCF_GPIO_PDDR_UARTH_PDDR_UARTH0          (0x01)
#define MCF_GPIO_PDDR_UARTH_PDDR_UARTH1          (0x02)

/* Bit definitions and macros for MCF_GPIO_PDDR_UARTL */
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL0          (0x01)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL1          (0x02)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL2          (0x04)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL3          (0x08)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL4          (0x10)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL5          (0x20)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL6          (0x40)
#define MCF_GPIO_PDDR_UARTL_PDDR_UARTL7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PDDR_QSPI */
#define MCF_GPIO_PDDR_QSPI_PDDR_QSPI0            (0x01)
#define MCF_GPIO_PDDR_QSPI_PDDR_QSPI1            (0x02)
#define MCF_GPIO_PDDR_QSPI_PDDR_QSPI2            (0x04)
#define MCF_GPIO_PDDR_QSPI_PDDR_QSPI3            (0x08)
#define MCF_GPIO_PDDR_QSPI_PDDR_QSPI4            (0x10)

/* Bit definitions and macros for MCF_GPIO_PDDR_TIMER */
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER0          (0x01)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER1          (0x02)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER2          (0x04)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER3          (0x08)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER4          (0x10)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER5          (0x20)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER6          (0x40)
#define MCF_GPIO_PDDR_TIMER_PDDR_TIMER7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_ADDR */
#define MCF_GPIO_PPDSDR_ADDR_PPDSDR_ADDR5        (0x20)
#define MCF_GPIO_PPDSDR_ADDR_PPDSDR_ADDR6        (0x40)
#define MCF_GPIO_PPDSDR_ADDR_PPDSDR_ADDR7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_DATAH */
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH0      (0x01)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH1      (0x02)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH2      (0x04)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH3      (0x08)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH4      (0x10)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH5      (0x20)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH6      (0x40)
#define MCF_GPIO_PPDSDR_DATAH_PPDSDR_DATAH7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_DATAL */
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL0      (0x01)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL1      (0x02)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL2      (0x04)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL3      (0x08)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL4      (0x10)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL5      (0x20)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL6      (0x40)
#define MCF_GPIO_PPDSDR_DATAL_PPDSDR_DATAL7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_BUSCTL */
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL0    (0x01)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL1    (0x02)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL2    (0x04)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL3    (0x08)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL4    (0x10)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL5    (0x20)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL6    (0x40)
#define MCF_GPIO_PPDSDR_BUSCTL_PPDSDR_BUSCTL7    (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_BS */
#define MCF_GPIO_PPDSDR_BS_PPDSDR_BS0            (0x01)
#define MCF_GPIO_PPDSDR_BS_PPDSDR_BS1            (0x02)
#define MCF_GPIO_PPDSDR_BS_PPDSDR_BS2            (0x04)
#define MCF_GPIO_PPDSDR_BS_PPDSDR_BS3            (0x08)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_FECI2C */
#define MCF_GPIO_PPDSDR_FECI2C_PPDSDR_FECI2C0    (0x01)
#define MCF_GPIO_PPDSDR_FECI2C_PPDSDR_FECI2C1    (0x02)
#define MCF_GPIO_PPDSDR_FECI2C_PPDSDR_FECI2C2    (0x04)
#define MCF_GPIO_PPDSDR_FECI2C_PPDSDR_FECI2C3    (0x08)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_CS */
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS1            (0x02)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS2            (0x04)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS3            (0x08)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS4            (0x10)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS5            (0x20)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS6            (0x40)
#define MCF_GPIO_PPDSDR_CS_PPDSDR_CS7            (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_SDRAM */
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM0      (0x01)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM1      (0x02)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM2      (0x04)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM3      (0x08)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM4      (0x10)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM5      (0x20)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM6      (0x40)
#define MCF_GPIO_PPDSDR_SDRAM_PPDSDR_SDRAM7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_UARTH */
#define MCF_GPIO_PPDSDR_UARTH_PPDSDR_UARTH0      (0x01)
#define MCF_GPIO_PPDSDR_UARTH_PPDSDR_UARTH1      (0x02)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_UARTL */
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL0      (0x01)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL1      (0x02)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL2      (0x04)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL3      (0x08)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL4      (0x10)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL5      (0x20)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL6      (0x40)
#define MCF_GPIO_PPDSDR_UARTL_PPDSDR_UARTL7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_QSPI */
#define MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI0        (0x01)
#define MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI1        (0x02)
#define MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI2        (0x04)
#define MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI3        (0x08)
#define MCF_GPIO_PPDSDR_QSPI_PPDSDR_QSPI4        (0x10)

/* Bit definitions and macros for MCF_GPIO_PPDSDR_TIMER */
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER0      (0x01)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER1      (0x02)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER2      (0x04)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER3      (0x08)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER4      (0x10)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER5      (0x20)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER6      (0x40)
#define MCF_GPIO_PPDSDR_TIMER_PPDSDR_TIMER7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_ADDR */
#define MCF_GPIO_PCLRR_ADDR_PCLRR_ADDR5          (0x20)
#define MCF_GPIO_PCLRR_ADDR_PCLRR_ADDR6          (0x40)
#define MCF_GPIO_PCLRR_ADDR_PCLRR_ADDR7          (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_DATAH */
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH0        (0x01)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH1        (0x02)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH2        (0x04)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH3        (0x08)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH4        (0x10)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH5        (0x20)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH6        (0x40)
#define MCF_GPIO_PCLRR_DATAH_PCLRR_DATAH7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_DATAL */
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL0        (0x01)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL1        (0x02)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL2        (0x04)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL3        (0x08)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL4        (0x10)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL5        (0x20)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL6        (0x40)
#define MCF_GPIO_PCLRR_DATAL_PCLRR_DATAL7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_BUSCTL */
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL0      (0x01)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL1      (0x02)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL2      (0x04)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL3      (0x08)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL4      (0x10)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL5      (0x20)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL6      (0x40)
#define MCF_GPIO_PCLRR_BUSCTL_PCLRR_BUSCTL7      (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_BS */
#define MCF_GPIO_PCLRR_BS_PCLRR_BS0              (0x01)
#define MCF_GPIO_PCLRR_BS_PCLRR_BS1              (0x02)
#define MCF_GPIO_PCLRR_BS_PCLRR_BS2              (0x04)
#define MCF_GPIO_PCLRR_BS_PCLRR_BS3              (0x08)

/* Bit definitions and macros for MCF_GPIO_PCLRR_CS */
#define MCF_GPIO_PCLRR_CS_PCLRR_CS1              (0x02)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS2              (0x04)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS3              (0x08)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS4              (0x10)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS5              (0x20)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS6              (0x40)
#define MCF_GPIO_PCLRR_CS_PCLRR_CS7              (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_SDRAM */
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM0        (0x01)
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM1        (0x02)
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM2        (0x04)
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM3        (0x08)
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM4        (0x10)
#define MCF_GPIO_PCLRR_SDRAM_PCLRR_SDRAM5        (0x20)

/* Bit definitions and macros for MCF_GPIO_PCLRR_FECI2C */
#define MCF_GPIO_PCLRR_FECI2C_PCLRR_FECI2C0      (0x01)
#define MCF_GPIO_PCLRR_FECI2C_PCLRR_FECI2C1      (0x02)
#define MCF_GPIO_PCLRR_FECI2C_PCLRR_FECI2C2      (0x04)
#define MCF_GPIO_PCLRR_FECI2C_PCLRR_FECI2C3      (0x08)

/* Bit definitions and macros for MCF_GPIO_PCLRR_UARTH */
#define MCF_GPIO_PCLRR_UARTH_PCLRR_UARTH0        (0x01)
#define MCF_GPIO_PCLRR_UARTH_PCLRR_UARTH1        (0x02)

/* Bit definitions and macros for MCF_GPIO_PCLRR_UARTL */
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL0        (0x01)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL1        (0x02)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL2        (0x04)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL3        (0x08)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL4        (0x10)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL5        (0x20)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL6        (0x40)
#define MCF_GPIO_PCLRR_UARTL_PCLRR_UARTL7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PCLRR_QSPI */
#define MCF_GPIO_PCLRR_QSPI_PCLRR_QSPI0          (0x01)
#define MCF_GPIO_PCLRR_QSPI_PCLRR_QSPI1          (0x02)
#define MCF_GPIO_PCLRR_QSPI_PCLRR_QSPI2          (0x04)
#define MCF_GPIO_PCLRR_QSPI_PCLRR_QSPI3          (0x08)
#define MCF_GPIO_PCLRR_QSPI_PCLRR_QSPI4          (0x10)

/* Bit definitions and macros for MCF_GPIO_PCLRR_TIMER */
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER0        (0x01)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER1        (0x02)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER2        (0x04)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER3        (0x08)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER4        (0x10)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER5        (0x20)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER6        (0x40)
#define MCF_GPIO_PCLRR_TIMER_PCLRR_TIMER7        (0x80)

/* Bit definitions and macros for MCF_GPIO_PAR_AD */
#define MCF_GPIO_PAR_AD_PAR_DATAL                (0x01)
#define MCF_GPIO_PAR_AD_PAR_ADDR21               (0x20)
#define MCF_GPIO_PAR_AD_PAR_ADDR22               (0x40)
#define MCF_GPIO_PAR_AD_PAR_ADDR23               (0x80)

/* Bit definitions and macros for MCF_GPIO_PAR_BUSCTL */
#define MCF_GPIO_PAR_BUSCTL_PAR_TIP(x)           (((x)&0x0003)<<0)
#define MCF_GPIO_PAR_BUSCTL_PAR_TS(x)            (((x)&0x0003)<<2)
#define MCF_GPIO_PAR_BUSCTL_PAR_TSIZ0            (0x0010)
#define MCF_GPIO_PAR_BUSCTL_PAR_TSIZ1            (0x0040)
#define MCF_GPIO_PAR_BUSCTL_PAR_RWB              (0x0100)
#define MCF_GPIO_PAR_BUSCTL_PAR_TEA(x)           (((x)&0x0003)<<10)
#define MCF_GPIO_PAR_BUSCTL_PAR_TA               (0x1000)
#define MCF_GPIO_PAR_BUSCTL_PAR_OE               (0x4000)
#define MCF_GPIO_PAR_BUSCTL_PAR_TEA_GPIO         (0x0000)
#define MCF_GPIO_PAR_BUSCTL_PAR_TEA_DMA          (0x0800)
#define MCF_GPIO_PAR_BUSCTL_PAR_TEA_TEA          (0x0C00)
#define MCF_GPIO_PAR_BUSCTL_PAR_TS_GPIO          (0x0000)
#define MCF_GPIO_PAR_BUSCTL_PAR_TS_DMA           (0x0080)
#define MCF_GPIO_PAR_BUSCTL_PAR_TS_TS            (0x00C0)
#define MCF_GPIO_PAR_BUSCTL_PAR_TIP_GPIO         (0x0000)
#define MCF_GPIO_PAR_BUSCTL_PAR_TIP_DMA          (0x0002)
#define MCF_GPIO_PAR_BUSCTL_PAR_TIP_TEA          (0x0003)

/* Bit definitions and macros for MCF_GPIO_PAR_BS */
#define MCF_GPIO_PAR_BS_PAR_BS0                  (0x01)
#define MCF_GPIO_PAR_BS_PAR_BS1                  (0x02)
#define MCF_GPIO_PAR_BS_PAR_BS2                  (0x04)
#define MCF_GPIO_PAR_BS_PAR_BS3                  (0x08)

/* Bit definitions and macros for MCF_GPIO_PAR_CS */
#define MCF_GPIO_PAR_CS_PAR_CS1                  (0x02)
#define MCF_GPIO_PAR_CS_PAR_CS2                  (0x04)
#define MCF_GPIO_PAR_CS_PAR_CS3                  (0x08)
#define MCF_GPIO_PAR_CS_PAR_CS4                  (0x10)
#define MCF_GPIO_PAR_CS_PAR_CS5                  (0x20)
#define MCF_GPIO_PAR_CS_PAR_CS6                  (0x40)
#define MCF_GPIO_PAR_CS_PAR_CS7                  (0x80)

/* Bit definitions and macros for MCF_GPIO_PAR_SDRAM */
#define MCF_GPIO_PAR_SDRAM_PAR_SDCS0             (0x01)
#define MCF_GPIO_PAR_SDRAM_PAR_SDCS1             (0x02)
#define MCF_GPIO_PAR_SDRAM_PAR_SCKE              (0x04)
#define MCF_GPIO_PAR_SDRAM_PAR_SRAS              (0x08)
#define MCF_GPIO_PAR_SDRAM_PAR_SCAS              (0x10)
#define MCF_GPIO_PAR_SDRAM_PAR_SDWE              (0x20)
#define MCF_GPIO_PAR_SDRAM_PAR_CSSDCS(x)         (((x)&0x03)<<6)

/* Bit definitions and macros for MCF_GPIO_PAR_FECI2C */
#define MCF_GPIO_PAR_FECI2C_PAR_SDA(x)           (((x)&0x03)<<0)
#define MCF_GPIO_PAR_FECI2C_PAR_SCL(x)           (((x)&0x03)<<2)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDIO(x)         (((x)&0x03)<<4)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDC(x)          (((x)&0x03)<<6)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDC_GPIO        (0x00)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDC_UART2       (0x40)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDC_I2C         (0x80)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDC_FEC         (0xC0)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDIO_GPIO       (0x00)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDIO_UART2      (0x10)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDIO_I2C        (0x20)
#define MCF_GPIO_PAR_FECI2C_PAR_EMDIO_FEC        (0x30)
#define MCF_GPIO_PAR_FECI2C_PAR_SCL_GPIO         (0x00)
#define MCF_GPIO_PAR_FECI2C_PAR_SCL_FLEX         (0x08)
#define MCF_GPIO_PAR_FECI2C_PAR_SCL_I2C          (0x0C)
#define MCF_GPIO_PAR_FECI2C_PAR_SDA_GPIO         (0x00)
#define MCF_GPIO_PAR_FECI2C_PAR_SDA_FLEX         (0x02)
#define MCF_GPIO_PAR_FECI2C_PAR_SDA_I2C          (0x03)

/* Bit definitions and macros for MCF_GPIO_PAR_UART */
#define MCF_GPIO_PAR_UART_PAR_U0RTS              (0x0001)
#define MCF_GPIO_PAR_UART_PAR_U0CTS              (0x0002)
#define MCF_GPIO_PAR_UART_PAR_U0TXD              (0x0004)
#define MCF_GPIO_PAR_UART_PAR_U0RXD              (0x0008)
#define MCF_GPIO_PAR_UART_PAR_U1RTS(x)           (((x)&0x0003)<<4)
#define MCF_GPIO_PAR_UART_PAR_U1CTS(x)           (((x)&0x0003)<<6)
#define MCF_GPIO_PAR_UART_PAR_U1TXD(x)           (((x)&0x0003)<<8)
#define MCF_GPIO_PAR_UART_PAR_U1RXD(x)           (((x)&0x0003)<<10)
#define MCF_GPIO_PAR_UART_PAR_U2TXD              (0x1000)
#define MCF_GPIO_PAR_UART_PAR_U2RXD              (0x2000)
#define MCF_GPIO_PAR_UART_PAR_CAN1EN             (0x4000)
#define MCF_GPIO_PAR_UART_PAR_DREQ2              (0x8000)
#define MCF_GPIO_PAR_UART_PAR_U1RXD_GPIO         (0x0000)
#define MCF_GPIO_PAR_UART_PAR_U1RXD_FLEX         (0x0800)
#define MCF_GPIO_PAR_UART_PAR_U1RXD_UART1        (0x0C00)
#define MCF_GPIO_PAR_UART_PAR_U1TXD_GPIO         (0x0000)
#define MCF_GPIO_PAR_UART_PAR_U1TXD_FLEX         (0x0200)
#define MCF_GPIO_PAR_UART_PAR_U1TXD_UART1        (0x0300)
#define MCF_GPIO_PAR_UART_PAR_U1CTS_GPIO         (0x0000)
#define MCF_GPIO_PAR_UART_PAR_U1CTS_UART2        (0x0080)
#define MCF_GPIO_PAR_UART_PAR_U1CTS_UART1        (0x00C0)
#define MCF_GPIO_PAR_UART_PAR_U1RTS_GPIO         (0x0000)
#define MCF_GPIO_PAR_UART_PAR_U1RTS_UART2        (0x0020)
#define MCF_GPIO_PAR_UART_PAR_U1RTS_UART1        (0x0030)

/* Bit definitions and macros for MCF_GPIO_PAR_QSPI */
#define MCF_GPIO_PAR_QSPI_PAR_SCK(x)             (((x)&0x03)<<0)
#define MCF_GPIO_PAR_QSPI_PAR_DOUT               (0x04)
#define MCF_GPIO_PAR_QSPI_PAR_DIN(x)             (((x)&0x03)<<3)
#define MCF_GPIO_PAR_QSPI_PAR_PCS0               (0x20)
#define MCF_GPIO_PAR_QSPI_PAR_PCS1(x)            (((x)&0x03)<<6)
#define MCF_GPIO_PAR_QSPI_PAR_PCS1_GPIO          (0x00)
#define MCF_GPIO_PAR_QSPI_PAR_PCS1_SDRAMC        (0x80)
#define MCF_GPIO_PAR_QSPI_PAR_PCS1_QSPI          (0xC0)
#define MCF_GPIO_PAR_QSPI_PAR_DIN_GPIO           (0x00)
#define MCF_GPIO_PAR_QSPI_PAR_DIN_I2C            (0x10)
#define MCF_GPIO_PAR_QSPI_PAR_DIN_QSPI           (0x1C)
#define MCF_GPIO_PAR_QSPI_PAR_SCK_GPIO           (0x00)
#define MCF_GPIO_PAR_QSPI_PAR_SCK_I2C            (0x02)
#define MCF_GPIO_PAR_QSPI_PAR_SCK_QSPI           (0x03)

/* Bit definitions and macros for MCF_GPIO_PAR_TIMER */
#define MCF_GPIO_PAR_TIMER_PAR_T0OUT(x)          (((x)&0x0003)<<0)
#define MCF_GPIO_PAR_TIMER_PAR_T1OUT(x)          (((x)&0x0003)<<2)
#define MCF_GPIO_PAR_TIMER_PAR_T2OUT(x)          (((x)&0x0003)<<4)
#define MCF_GPIO_PAR_TIMER_PAR_T3OUT(x)          (((x)&0x0003)<<6)
#define MCF_GPIO_PAR_TIMER_PAR_T0IN(x)           (((x)&0x0003)<<8)
#define MCF_GPIO_PAR_TIMER_PAR_T1IN(x)           (((x)&0x0003)<<10)
#define MCF_GPIO_PAR_TIMER_PAR_T2IN(x)           (((x)&0x0003)<<12)
#define MCF_GPIO_PAR_TIMER_PAR_T3IN(x)           (((x)&0x0003)<<14)
#define MCF_GPIO_PAR_TIMER_PAR_T3IN_GPIO         (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T3IN_QSPI         (0x4000)
#define MCF_GPIO_PAR_TIMER_PAR_T3IN_UART2        (0x8000)
#define MCF_GPIO_PAR_TIMER_PAR_T3IN_T3IN         (0xC000)
#define MCF_GPIO_PAR_TIMER_PAR_T2IN_GPIO         (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T2IN_T2OUT        (0x1000)
#define MCF_GPIO_PAR_TIMER_PAR_T2IN_DMA          (0x2000)
#define MCF_GPIO_PAR_TIMER_PAR_T2IN_T2IN         (0x3000)
#define MCF_GPIO_PAR_TIMER_PAR_T1IN_GPIO         (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T1IN_T1OUT        (0x0400)
#define MCF_GPIO_PAR_TIMER_PAR_T1IN_DMA          (0x0800)
#define MCF_GPIO_PAR_TIMER_PAR_T1IN_T1IN         (0x0C00)
#define MCF_GPIO_PAR_TIMER_PAR_T0IN_GPIO         (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T0IN_DMA          (0x0200)
#define MCF_GPIO_PAR_TIMER_PAR_T0IN_T0IN         (0x0300)
#define MCF_GPIO_PAR_TIMER_PAR_T3OUT_GPIO        (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T3OUT_QSPI        (0x0040)
#define MCF_GPIO_PAR_TIMER_PAR_T3OUT_UART2       (0x0080)
#define MCF_GPIO_PAR_TIMER_PAR_T3OUT_T3OUT       (0x00C0)
#define MCF_GPIO_PAR_TIMER_PAR_T2OUT_GPIO        (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T2OUT_DMA         (0x0020)
#define MCF_GPIO_PAR_TIMER_PAR_T2OUT_T2OUT       (0x0030)
#define MCF_GPIO_PAR_TIMER_PAR_T1OUT_GPIO        (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T1OUT_DMA         (0x0008)
#define MCF_GPIO_PAR_TIMER_PAR_T1OUT_T1OUT       (0x000C)
#define MCF_GPIO_PAR_TIMER_PAR_T0OUT_GPIO        (0x0000)
#define MCF_GPIO_PAR_TIMER_PAR_T0OUT_DMA         (0x0002)
#define MCF_GPIO_PAR_TIMER_PAR_T0OUT_T0OUT       (0x0003)

/* Bit definitions and macros for MCF_GPIO_DSCR_EIM */
#define MCF_GPIO_DSCR_EIM_DSCR_EIM0              (0x01)
#define MCF_GPIO_DSCR_EIM_DSCR_EIM1              (0x10)

/* Bit definitions and macros for MCF_GPIO_DSCR_FECI2C */
#define MCF_GPIO_DSCR_FECI2C_DSCR_I2C            (0x01)
#define MCF_GPIO_DSCR_FECI2C_DSCR_FEC            (0x10)

/* Bit definitions and macros for MCF_GPIO_DSCR_UART */
#define MCF_GPIO_DSCR_UART_DSCR_UART0            (0x01)
#define MCF_GPIO_DSCR_UART_DSCR_UART1            (0x04)
#define MCF_GPIO_DSCR_UART_DSCR_UART2            (0x10)
#define MCF_GPIO_DSCR_UART_DSCR_IRQ              (0x40)

/* Bit definitions and macros for MCF_GPIO_DSCR_QSPI */
#define MCF_GPIO_DSCR_QSPI_DSCR_QSPI             (0x01)

/* Bit definitions and macros for MCF_GPIO_DSCR_TIMER */
#define MCF_GPIO_DSCR_TIMER_DSCR_TIMER           (0x01)

/*********************************************************************
*
* DMA Timers (DTIM0-DTIM3)
*
*********************************************************************/

//* DMA Timer 0 Register macros */
#define MCF_DTM_DTMR0		MCF_REG16(MCF_IPSBAR + 0x400)		/* DMA Timer Mode Register 0 (16 Bit) */
#define MCF_DTM_DTXMR0		MCF_REG08(MCF_IPSBAR + 0x402)		/* DMA Timer Extended Mode Register 0 (8 Bit) */
#define MCF_DTM_DTER0		MCF_REG08(MCF_IPSBAR + 0x403)		/* DMA Timer Event Register 0 (8 Bit) */
#define MCF_DTM_DTRR0		MCF_REG32(MCF_IPSBAR + 0x404)		/* DMA Timer Reference Register 0 (32 Bit) */
#define MCF_DTM_DTCR0		MCF_REG32(MCF_IPSBAR + 0x408)		/* DMA Timer Capture Register 0 (32 Bit) */
#define MCF_DTM_DTCN0		MCF_REG32(MCF_IPSBAR + 0x40C)		/* DMA Timer Counter Register 0 (32 Bit) */
/* DMA Timer 1 Register macros*/
#define MCF_DTM_DTMR1		MCF_REG16(MCF_IPSBAR + 0x440)		/* DMA Timer Mode Register 1 (16 Bit) */
#define MCF_DTM_DTXMR1		MCF_REG08(MCF_IPSBAR + 0x442)		/* DMA Timer Extended Mode Register 1 (8 Bit) */
#define MCF_DTM_DTER1		MCF_REG08(MCF_IPSBAR + 0x443)		/* DMA Timer Event Register 1 (8 Bit) */
#define MCF_DTM_DTRR1		MCF_REG32(MCF_IPSBAR + 0x444)		/* DMA Timer Reference Register 1 (32 Bit) */
#define MCF_DTM_DTCR1		MCF_REG32(MCF_IPSBAR + 0x448)		/* DMA Timer Capture Register 1 (32 Bit) */
#define MCF_DTM_DTCN1		MCF_REG32(MCF_IPSBAR + 0x44C)		/* DMA Timer Counter Register 1 (32 Bit) */
/* DMA Timer 2 Register macros*/
#define MCF_DTM_DTMR2		MCF_REG16(MCF_IPSBAR + 0x480)		/* DMA Timer Mode Register 2 (16 Bit) */
#define MCF_DTM_DTXMR2		MCF_REG08(MCF_IPSBAR + 0x482)		/* DMA Timer Extended Mode Register 2 (8 Bit) */
#define MCF_DTM_DTER2		MCF_REG08(MCF_IPSBAR + 0x483)		/* DMA Timer Event Register 2 (8 Bit) */
#define MCF_DTM_DTRR2		MCF_REG32(MCF_IPSBAR + 0x484)		/* DMA Timer Reference Register 2 (32 Bit) */
#define MCF_DTM_DTCR2		MCF_REG32(MCF_IPSBAR + 0x488)		/* DMA Timer Capture Register 2 (32 Bit) */
#define MCF_DTM_DTCN2		MCF_REG32(MCF_IPSBAR + 0x48C)		/* DMA Timer Counter Register 2 (32 Bit) */
/* DMA Timer 3 Register macros*/
#define MCF_DTM_DTMR3		MCF_REG16(MCF_IPSBAR + 0x4C0)		/* DMA Timer Mode Register 3 (16 Bit) */
#define MCF_DTM_DTXMR3		MCF_REG08(MCF_IPSBAR + 0x4C2)		/* DMA Timer Extended Mode Register 3 (8 Bit) */
#define MCF_DTM_DTER3		MCF_REG08(MCF_IPSBAR + 0x4C3)		/* DMA Timer Event Register 3 (8 Bit) */
#define MCF_DTM_DTRR3		MCF_REG32(MCF_IPSBAR + 0x4C4)		/* DMA Timer Reference Register 3 (32 Bit) */
#define MCF_DTM_DTCR3		MCF_REG32(MCF_IPSBAR + 0x4C8)		/* DMA Timer Capture Register 3 (32 Bit) */
#define MCF_DTM_DTCN3		MCF_REG32(MCF_IPSBAR + 0x4CC)		/* DMA Timer Counter Register 3 (32 Bit) */

/*********************************************************************
 *
 * Edge Port Module (EPORT)
 *
 *********************************************************************/

/* Register read/write macros */
#define MCF_EPORT_EPPAR		MCF_REG16(MCF_IPSBAR + 0x130000)	/* EPORT Pin assignment register */
#define MCF_EPORT_EPDDR		MCF_REG08(MCF_IPSBAR + 0x130002)	/* EPORT Data Direction register */
#define MCF_EPORT_EPIER		MCF_REG08(MCF_IPSBAR + 0x130003)	/* EPORT Interrupt enable register */
#define MCF_EPORT_EPDR		MCF_REG08(MCF_IPSBAR + 0x130004)	/* EPORT Data register */
#define MCF_EPORT_EPPDR		MCF_REG08(MCF_IPSBAR + 0x130005)	/* EPORT Pin Data register */
#define MCF_EPORT_EPFR		MCF_REG08(MCF_IPSBAR + 0x130006)	/* EPORT Flag register */

/* Bit definitions and macros for MCF_EPORT_EPPAR */
#define MCF_EPORT_EPPAR_EPPA1(x)       (((x)&0x0003)<<2)
#define MCF_EPORT_EPPAR_EPPA2(x)       (((x)&0x0003)<<4)
#define MCF_EPORT_EPPAR_EPPA3(x)       (((x)&0x0003)<<6)
#define MCF_EPORT_EPPAR_EPPA4(x)       (((x)&0x0003)<<8)
#define MCF_EPORT_EPPAR_EPPA5(x)       (((x)&0x0003)<<10)
#define MCF_EPORT_EPPAR_EPPA6(x)       (((x)&0x0003)<<12)
#define MCF_EPORT_EPPAR_EPPA7(x)       (((x)&0x0003)<<14)
#define MCF_EPORT_EPPAR_LEVEL          (0)
#define MCF_EPORT_EPPAR_RISING         (1)
#define MCF_EPORT_EPPAR_FALLING        (2)
#define MCF_EPORT_EPPAR_BOTH           (3)
#define MCF_EPORT_EPPAR_EPPA7_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA7_RISING   (0x4000)
#define MCF_EPORT_EPPAR_EPPA7_FALLING  (0x8000)
#define MCF_EPORT_EPPAR_EPPA7_BOTH     (0xC000)
#define MCF_EPORT_EPPAR_EPPA6_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA6_RISING   (0x1000)
#define MCF_EPORT_EPPAR_EPPA6_FALLING  (0x2000)
#define MCF_EPORT_EPPAR_EPPA6_BOTH     (0x3000)
#define MCF_EPORT_EPPAR_EPPA5_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA5_RISING   (0x0400)
#define MCF_EPORT_EPPAR_EPPA5_FALLING  (0x0800)
#define MCF_EPORT_EPPAR_EPPA5_BOTH     (0x0C00)
#define MCF_EPORT_EPPAR_EPPA4_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA4_RISING   (0x0100)
#define MCF_EPORT_EPPAR_EPPA4_FALLING  (0x0200)
#define MCF_EPORT_EPPAR_EPPA4_BOTH     (0x0300)
#define MCF_EPORT_EPPAR_EPPA3_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA3_RISING   (0x0040)
#define MCF_EPORT_EPPAR_EPPA3_FALLING  (0x0080)
#define MCF_EPORT_EPPAR_EPPA3_BOTH     (0x00C0)
#define MCF_EPORT_EPPAR_EPPA2_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA2_RISING   (0x0010)
#define MCF_EPORT_EPPAR_EPPA2_FALLING  (0x0020)
#define MCF_EPORT_EPPAR_EPPA2_BOTH     (0x0030)
#define MCF_EPORT_EPPAR_EPPA1_LEVEL    (0x0000)
#define MCF_EPORT_EPPAR_EPPA1_RISING   (0x0004)
#define MCF_EPORT_EPPAR_EPPA1_FALLING  (0x0008)
#define MCF_EPORT_EPPAR_EPPA1_BOTH     (0x000C)

/* Bit definitions and macros for MCF_EPORT_EPDDR */
#define MCF_EPORT_EPDDR_EPDD1          (0x02)
#define MCF_EPORT_EPDDR_EPDD2          (0x04)
#define MCF_EPORT_EPDDR_EPDD3          (0x08)
#define MCF_EPORT_EPDDR_EPDD4          (0x10)
#define MCF_EPORT_EPDDR_EPDD5          (0x20)
#define MCF_EPORT_EPDDR_EPDD6          (0x40)
#define MCF_EPORT_EPDDR_EPDD7          (0x80)

/* Bit definitions and macros for MCF_EPORT_EPIER */
#define MCF_EPORT_EPIER_EPIE1          (0x02)
#define MCF_EPORT_EPIER_EPIE2          (0x04)
#define MCF_EPORT_EPIER_EPIE3          (0x08)
#define MCF_EPORT_EPIER_EPIE4          (0x10)
#define MCF_EPORT_EPIER_EPIE5          (0x20)
#define MCF_EPORT_EPIER_EPIE6          (0x40)
#define MCF_EPORT_EPIER_EPIE7          (0x80)

/* Bit definitions and macros for MCF_EPORT_EPDR */
#define MCF_EPORT_EPDR_EPD1            (0x02)
#define MCF_EPORT_EPDR_EPD2            (0x04)
#define MCF_EPORT_EPDR_EPD3            (0x08)
#define MCF_EPORT_EPDR_EPD4            (0x10)
#define MCF_EPORT_EPDR_EPD5            (0x20)
#define MCF_EPORT_EPDR_EPD6            (0x40)
#define MCF_EPORT_EPDR_EPD7            (0x80)

/* Bit definitions and macros for MCF_EPORT_EPPDR */
#define MCF_EPORT_EPPDR_EPPD1          (0x02)
#define MCF_EPORT_EPPDR_EPPD2          (0x04)
#define MCF_EPORT_EPPDR_EPPD3          (0x08)
#define MCF_EPORT_EPPDR_EPPD4          (0x10)
#define MCF_EPORT_EPPDR_EPPD5          (0x20)
#define MCF_EPORT_EPPDR_EPPD6          (0x40)
#define MCF_EPORT_EPPDR_EPPD7          (0x80)

/* Bit definitions and macros for MCF_EPORT_EPFR */
#define MCF_EPORT_EPFR_EPF1            (0x02)
#define MCF_EPORT_EPFR_EPF2            (0x04)
#define MCF_EPORT_EPFR_EPF3            (0x08)
#define MCF_EPORT_EPFR_EPF4            (0x10)
#define MCF_EPORT_EPFR_EPF5            (0x20)
#define MCF_EPORT_EPFR_EPF6            (0x40)
#define MCF_EPORT_EPFR_EPF7            (0x80)

/****************************************************************************/
#endif	/* m527xsim_h */
